/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon;

import com.ibm.nmon.analysis.AnalysisRecord;
import com.ibm.nmon.data.BasicDataSet;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataSetListener;
import com.ibm.nmon.data.SystemDataSet;
import com.ibm.nmon.data.transform.name.HostRenamer;
import com.ibm.nmon.file.CombinedFileFilter;
import com.ibm.nmon.interval.Interval;
import com.ibm.nmon.interval.IntervalListener;
import com.ibm.nmon.interval.IntervalManager;
import com.ibm.nmon.parser.HATJParser;
import com.ibm.nmon.parser.IOStatParser;
import com.ibm.nmon.parser.JSONParser;
import com.ibm.nmon.parser.NMONParser;
import com.ibm.nmon.parser.PerfmonParser;
import com.ibm.nmon.parser.gc.VerboseGCParser;
import com.ibm.nmon.util.ParserLog;
import com.ibm.nmon.util.TimeFormatCache;
import com.ibm.nmon.util.TimeZoneFactory;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NMONVisualizerApp
implements IntervalListener {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final NMONParser nmonParser;
    private final VerboseGCParser gcParser;
    private final IOStatParser iostatParser;
    private final JSONParser jsonParser;
    private final HATJParser hatJParser;
    private final PerfmonParser perfmonParser;
    private HostRenamer hostRenamer;
    private final Set<DataSetListener> listeners;
    private final IntervalManager intervalManager = new IntervalManager();
    private TimeZone displayTimeZone;
    private final Map<SystemDataSet, AnalysisRecord> analysisRecords = new TreeMap<SystemDataSet, AnalysisRecord>();
    private long minSystemTime = 0L;
    private long maxSystemTime = Long.MAX_VALUE;
    private final Properties properties = new Properties();
    protected final PropertyChangeSupport propertyChangeSupport;

    protected NMONVisualizerApp() {
        ParserLog.getInstance();
        this.nmonParser = new NMONParser();
        this.gcParser = new VerboseGCParser();
        this.iostatParser = new IOStatParser();
        this.jsonParser = new JSONParser();
        this.hatJParser = new HATJParser();
        this.perfmonParser = new PerfmonParser();
        TimeZone defaultTz = TimeZone.getDefault();
        for (TimeZone timeZone : TimeZoneFactory.TIMEZONES) {
            long defaultOffset = defaultTz.getOffset(System.currentTimeMillis());
            if ((long)timeZone.getOffset(System.currentTimeMillis()) != defaultOffset) continue;
            this.displayTimeZone = timeZone;
            break;
        }
        if (this.displayTimeZone == null) {
            this.displayTimeZone = defaultTz;
        }
        TimeFormatCache.setTimeZone(this.displayTimeZone);
        this.listeners = new HashSet<DataSetListener>();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.intervalManager.addListener(this);
        this.setProperty("systemsNamedBy", "host");
        this.hostRenamer = HostRenamer.BY_HOST;
        this.setProperty("scaleProcessesByCPUs", "true");
    }

    public final void parse(String fileToParse, TimeZone timeZone) throws Exception {
        String hostname;
        fileToParse = fileToParse.replace('\\', '/');
        for (SystemDataSet systemData : this.analysisRecords.keySet()) {
            if (!systemData.containsSourceFile(fileToParse)) continue;
            return;
        }
        DataSet data = null;
        CombinedFileFilter filter = CombinedFileFilter.getInstance(false);
        if (filter.getNMONFileFilter().accept(fileToParse)) {
            data = this.nmonParser.parse(fileToParse, timeZone, this.getBooleanProperty("scaleProcessesByCPUs"));
        } else if (filter.getGCFileFilter().accept(fileToParse)) {
            Object[] values = this.getDataForGCParse(fileToParse);
            if (values == null) {
                this.logger.info("skipping file '{}'", (Object)fileToParse);
                return;
            }
            if (values.length < 2) {
                this.logger.error("need both hostname and JVM name to parse GC data, only {} provided", (Object)Arrays.toString(values));
                return;
            }
            data = this.gcParser.parse(fileToParse, timeZone, (String)values[0], (String)values[1]);
        } else if (filter.getIOStatFileFilter().accept(fileToParse)) {
            data = this.iostatParser.parse(fileToParse, this.getDisplayTimeZone());
            hostname = data.getHostname();
            boolean verifyDate = "AIX".equals(((BasicDataSet)data).getMetadata("OS"));
            if (hostname.equals("iostat") || verifyDate) {
                Object[] values = this.getDataForIOStatParse(fileToParse, hostname);
                if (values == null) {
                    this.logger.info("skipping file '{}'", (Object)fileToParse);
                    return;
                }
                hostname = (String)values[0];
                data.setHostname(hostname);
                long newDate = (Long)values[1];
                long defaultDate = IOStatParser.getDefaultDate();
                if (defaultDate != newDate) {
                    long start = System.nanoTime();
                    data.adjustTimes(newDate - defaultDate);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("data for '{}' times adjusted by {} hours in {} ms", new Object[]{fileToParse, (double)(newDate - defaultDate) / 3600.0 / 1000.0, System.nanoTime() - start});
                    }
                }
            }
        } else if (filter.getJSONFileFilter().accept(fileToParse)) {
            data = this.jsonParser.parse(fileToParse);
        } else if (filter.getHATJFileFilter().accept(fileToParse)) {
            data = this.hatJParser.parse(fileToParse);
            hostname = data.getHostname();
            if (hostname.equals("hatj")) {
                Object[] values = this.getDataForHATJParse(fileToParse, hostname);
                if (values == null) {
                    this.logger.info("skipping file '{}'", (Object)fileToParse);
                    return;
                }
                hostname = (String)values[0];
                data.setHostname(hostname);
            }
        } else if (filter.getPerfmonFileFilter().accept(fileToParse)) {
            data = this.perfmonParser.parse(fileToParse, this.getBooleanProperty("scaleProcessesByCPUs"));
        } else {
            throw new IllegalArgumentException("cannot parse " + fileToParse + ": unknown file type");
        }
        if (data.getRecordCount() == 0) {
            throw new IllegalArgumentException(fileToParse + " does not appear to contain any data");
        }
        this.hostRenamer.rename(data);
        SystemDataSet systemData = null;
        for (SystemDataSet toSearch : this.analysisRecords.keySet()) {
            if (!toSearch.getHostname().equals(data.getHostname())) continue;
            systemData = toSearch;
            break;
        }
        if (systemData == null) {
            systemData = new SystemDataSet(data.getHostname());
            AnalysisRecord record = new AnalysisRecord(systemData);
            record.setInterval(this.intervalManager.getCurrentInterval());
            this.analysisRecords.put(systemData, record);
        }
        systemData.addData(fileToParse, data);
        this.recalculateMinAndMaxSystemTime();
        this.fireDataAdded(systemData);
    }

    protected String[] getDataForGCParse(String fileToParse) {
        int idx = fileToParse.lastIndexOf(47);
        if (idx != -1) {
            fileToParse = fileToParse.substring(idx + 1);
        }
        return new String[]{fileToParse, fileToParse};
    }

    protected Object[] getDataForIOStatParse(String fileToParse, String hostname) {
        return new Object[]{"iostat", IOStatParser.getDefaultDate()};
    }

    protected Object[] getDataForHATJParse(String fileToParse, String hostname) {
        return new Object[]{"hatj"};
    }

    protected void fireDataAdded(DataSet data) {
        for (DataSetListener listener : this.listeners) {
            listener.dataAdded(data);
        }
    }

    public final void setHostRenamer(HostRenamer hostRenamer) {
        if (hostRenamer != null) {
            this.hostRenamer = hostRenamer;
        }
    }

    public final TimeZone getDisplayTimeZone() {
        return this.displayTimeZone;
    }

    public final void setDisplayTimeZone(TimeZone displayTimeZone) {
        if (displayTimeZone == null) {
            return;
        }
        if (!this.displayTimeZone.equals(displayTimeZone)) {
            TimeZone old = this.displayTimeZone;
            this.displayTimeZone = displayTimeZone;
            TimeFormatCache.setTimeZone(displayTimeZone);
            this.propertyChangeSupport.firePropertyChange("timeZone", old, this.displayTimeZone);
        }
    }

    public final void removeDataSet(DataSet data) {
        block4: {
            if (this.analysisRecords.remove(data) == null) break block4;
            this.recalculateMinAndMaxSystemTime();
            if (this.analysisRecords.isEmpty()) {
                for (DataSetListener listener : this.listeners) {
                    listener.dataCleared();
                }
            } else {
                for (DataSetListener listener : this.listeners) {
                    listener.dataRemoved(data);
                }
            }
        }
    }

    public final void updateDataSet(SystemDataSet data) {
        if (this.analysisRecords.remove(data) != null) {
            AnalysisRecord record = new AnalysisRecord(data);
            record.setInterval(this.intervalManager.getCurrentInterval());
            this.analysisRecords.put(data, record);
            this.recalculateMinAndMaxSystemTime();
            for (DataSetListener listener : this.listeners) {
                listener.dataChanged(data);
            }
        }
    }

    public final void clearDataSets() {
        this.minSystemTime = 0L;
        this.maxSystemTime = Long.MAX_VALUE;
        TimeFormatCache.setDefaultIntervalRange(this.minSystemTime, this.maxSystemTime);
        this.intervalManager.setCurrentInterval(Interval.DEFAULT);
        this.analysisRecords.clear();
        for (DataSetListener listener : this.listeners) {
            listener.dataCleared();
        }
    }

    public final Iterable<SystemDataSet> getDataSets() {
        return Collections.unmodifiableSet(this.analysisRecords.keySet());
    }

    public final int getDataSetCount() {
        return this.analysisRecords.size();
    }

    public final long getMinSystemTime() {
        return this.minSystemTime;
    }

    public final long getMaxSystemTime() {
        return this.maxSystemTime;
    }

    public final IntervalManager getIntervalManager() {
        return this.intervalManager;
    }

    public final AnalysisRecord getAnalysis(DataSet data) {
        return this.analysisRecords.get(data);
    }

    public final String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public final boolean getBooleanProperty(String name) {
        return Boolean.parseBoolean(this.properties.getProperty(name));
    }

    public final void setProperty(String name, String value) {
        String old = this.properties.getProperty(name);
        this.properties.setProperty(name, value);
        this.propertyChangeSupport.firePropertyChange(name, old, value);
    }

    public final void setProperty(String name, int value) {
        String temp = this.properties.getProperty(name);
        int old = -1;
        if (temp != null) {
            old = Integer.parseInt(temp);
        }
        this.properties.setProperty(name, Integer.toString(value));
        this.propertyChangeSupport.firePropertyChange(name, old, value);
    }

    public final void setProperty(String name, boolean value) {
        boolean old = this.getBooleanProperty(name);
        this.properties.setProperty(name, Boolean.toString(value));
        this.propertyChangeSupport.firePropertyChange(name, old, value);
    }

    private void recalculateMinAndMaxSystemTime() {
        if (this.analysisRecords.size() > 0) {
            long minStart = Long.MAX_VALUE;
            long maxEnd = Long.MIN_VALUE;
            for (DataSet dataSet : this.analysisRecords.keySet()) {
                if (dataSet.getStartTime() < minStart) {
                    minStart = dataSet.getStartTime();
                }
                if (dataSet.getEndTime() <= maxEnd) continue;
                maxEnd = dataSet.getEndTime();
            }
            boolean update = false;
            if (minStart != this.minSystemTime) {
                this.minSystemTime = minStart;
                update = true;
            }
            if (maxEnd != this.maxSystemTime) {
                this.maxSystemTime = maxEnd;
                update = true;
            }
            if (update && this.intervalManager.getCurrentInterval().equals(Interval.DEFAULT)) {
                TimeFormatCache.setDefaultIntervalRange(this.minSystemTime, this.maxSystemTime);
                this.intervalManager.setCurrentInterval(Interval.DEFAULT);
            }
        }
    }

    @Override
    public void intervalAdded(Interval interval) {
    }

    @Override
    public void intervalRemoved(Interval interval) {
    }

    @Override
    public void intervalsCleared() {
    }

    @Override
    public void currentIntervalChanged(Interval interval) {
        for (AnalysisRecord record : this.analysisRecords.values()) {
            record.setInterval(interval);
        }
    }

    @Override
    public void intervalRenamed(Interval interval) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataSetListener(DataSetListener listener) {
        if (listener != null) {
            Set<DataSetListener> set = this.listeners;
            synchronized (set) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataSetListener(DataSetListener listener) {
        Set<DataSetListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }
}

