/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon;

import com.ibm.nmon.NMONVisualizerApp;
import com.ibm.nmon.data.DataRecord;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataSetListener;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.Process;
import com.ibm.nmon.data.ProcessDataSet;
import com.ibm.nmon.data.ProcessDataType;
import com.ibm.nmon.file.CombinedFileFilter;
import com.ibm.nmon.util.FileHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.logging.LogManager;

public final class NMONVisualizerCmdLine
extends NMONVisualizerApp
implements DataSetListener {
    private static final SimpleDateFormat OUTPUT_FORMAT = new SimpleDateFormat("MM/dd/yy,HH:mm:ss,");
    private final Set<Long> timesMonitored = new TreeSet<Long>();

    public static void main(String[] args) throws Exception {
        LogManager.getLogManager().readConfiguration(NMONVisualizerCmdLine.class.getResourceAsStream("/cmdline.logging.properties"));
        NMONVisualizerCmdLine app = new NMONVisualizerCmdLine();
        app.addDataSetListener(app);
        File pathToParse = NMONVisualizerCmdLine.getPathToParse(args);
        ArrayList<String> toParse = new ArrayList<String>();
        FileHelper.recurseDirectories(Collections.singletonList(pathToParse), (FileFilter)CombinedFileFilter.getInstance(false), toParse);
        if (toParse.size() == 0) {
            if (pathToParse.isDirectory()) {
                System.err.println("no files to parse in " + pathToParse);
            } else {
                System.err.println(pathToParse + " is not a recognized file");
            }
            return;
        }
        for (String file : toParse) {
            System.out.print("Parsing file " + file + "... ");
            System.out.flush();
            try {
                app.parse(file, TimeZone.getDefault());
                System.out.println("Complete");
            }
            catch (Exception e) {
                System.out.println("Failed parsing " + file);
                e.printStackTrace();
            }
        }
        System.out.println();
        String outputDir = "";
        String baseName = "";
        if (pathToParse.isDirectory()) {
            outputDir = pathToParse.getAbsolutePath();
            baseName = "consolidated";
        } else {
            outputDir = pathToParse.getParentFile().getAbsolutePath();
            baseName = pathToParse.getName();
            int idx = baseName.lastIndexOf(46);
            if (idx != -1) {
                baseName = baseName.substring(0, idx);
            }
        }
        NMONVisualizerCmdLine.createMasterDetailFile(outputDir, baseName, app);
        for (DataSet dataSet : app.getDataSets()) {
            if (!(dataSet instanceof ProcessDataSet) || ((ProcessDataSet)dataSet).getProcessCount() <= 0) continue;
            NMONVisualizerCmdLine.createMasterDetailProcessFile(outputDir, baseName, app);
            NMONVisualizerCmdLine.createCommandsFile(outputDir, baseName, app);
            break;
        }
    }

    private static File getPathToParse(String[] args) throws IOException {
        String pathname;
        if (args.length < 1) {
            System.out.print("What is the path and/or base name you would like to analyze?: ");
            System.out.flush();
            BufferedReader sysin = new BufferedReader(new InputStreamReader(System.in));
            pathname = sysin.readLine();
            sysin.close();
        } else {
            pathname = args[0];
        }
        pathname = pathname.replace("\\", "/");
        return new File(pathname);
    }

    private static void createMasterDetailFile(String outputDir, String baseName, NMONVisualizerCmdLine app) throws IOException {
        String outputFile = outputDir + '/' + baseName + "_nmon.csv";
        List<DataType> typesToOutput = NMONVisualizerCmdLine.getTypesToOutput(app);
        System.out.print("Writing NMON data to master-detail CSV file to " + outputFile + "... ");
        System.out.flush();
        PrintWriter out = new PrintWriter(new FileWriter(outputFile));
        StringBuilder builder = new StringBuilder(512);
        builder.append("Date,Time,System,");
        for (DataType type : typesToOutput) {
            for (String field : type.getFields()) {
                builder.append(type.getId());
                builder.append('-');
                builder.append(field);
                builder.append(',');
            }
        }
        builder.deleteCharAt(builder.length() - 1);
        out.println(builder);
        Iterator<Object> i$ = app.timesMonitored.iterator();
        while (i$.hasNext()) {
            long time = (Long)i$.next();
            String dateTime = OUTPUT_FORMAT.format(new Date(time));
            for (DataSet dataSet : app.getDataSets()) {
                DataRecord record = dataSet.getRecord(time);
                if (record == null) continue;
                builder.setLength(0);
                builder.append(dateTime);
                builder.append(dataSet.getHostname());
                builder.append(',');
                for (DataType type : typesToOutput) {
                    DataType hostType = dataSet.getType(type.getId());
                    for (String field : type.getFields()) {
                        if (hostType != null && hostType.hasField(field)) {
                            builder.append(record.getData(hostType, field));
                        }
                        builder.append(',');
                    }
                }
                builder.deleteCharAt(builder.length() - 1);
                out.println(builder);
            }
        }
        out.close();
        System.out.println("Complete");
    }

    private static List<DataType> getTypesToOutput(NMONVisualizerCmdLine app) {
        HashSet<String> networks = new HashSet<String>();
        HashSet<String> disks = new HashSet<String>();
        for (DataSet dataSet : app.getDataSets()) {
            DataType parsedNetwork = dataSet.getType("NET");
            for (int i = 0; i < parsedNetwork.getFieldCount(); ++i) {
                String field = parsedNetwork.getField(i);
                if (!field.startsWith("eth") && !field.startsWith("en")) continue;
                networks.add(field);
            }
            disks.addAll(dataSet.getType("DISKBUSY").getFields());
            disks.addAll(dataSet.getType("DISKREAD").getFields());
            disks.addAll(dataSet.getType("DISKWRITE").getFields());
            disks.addAll(dataSet.getType("DISKXFER").getFields());
        }
        disks.add("Total");
        ArrayList<DataType> types = new ArrayList<DataType>(5);
        types.add(new DataType("CPU_ALL", "CPU Total", "User%", "Sys%", "Wait%", "CPU%"));
        types.add(new DataType("NET", "Network I/O", networks.toArray(new String[0])));
        String[] stringArray = disks.toArray(new String[0]);
        types.add(new DataType("DISKBUSY", "Disk %Busy", stringArray));
        types.add(new DataType("DISKREAD", "Disk Read KB/s", stringArray));
        types.add(new DataType("DISKWRITE", "Disk Write KB/s", stringArray));
        types.add(new DataType("DISKXFER", "Disk transfers per second", stringArray));
        types.add(new DataType("VM", "Paging and Virtual Memory", "pgpgin", "pgpgout", "pswpin", "pswpout"));
        types.add(new DataType("PAGE", "Paging and Virtual Memory", "pgin", "pgout", "pgsin", "pgsout"));
        types.add(new DataType("MEM", "Memory MB", "memfree", "Real free(MB)"));
        types.add(new DataType("PROC", "Processes", "Runnable", "Swap-in", "pswitch", "syscall"));
        return types;
    }

    private static void createMasterDetailProcessFile(String outputDir, String baseName, NMONVisualizerCmdLine app) throws IOException {
        ArrayList<ProcessDataSet> dataSets = new ArrayList<ProcessDataSet>(app.getDataSetCount());
        for (DataSet dataSet : app.getDataSets()) {
            if (!(dataSet instanceof ProcessDataSet)) continue;
            dataSets.add((ProcessDataSet)dataSet);
        }
        String outputFile = outputDir + '/' + baseName + "_top.csv";
        System.out.print("Writing TOP data to master-detail CSV file to " + outputFile + "... ");
        System.out.flush();
        PrintWriter printWriter = new PrintWriter(new FileWriter(outputFile));
        StringBuilder builder = new StringBuilder(512);
        builder.append("Date,Time,Command,CPU%");
        printWriter.println(builder);
        for (long time : app.timesMonitored) {
            for (DataSet dataSet : dataSets) {
                DataRecord record = dataSet.getRecord(time);
                if (record == null) continue;
                for (Process p : ((ProcessDataSet)dataSet).getProcesses()) {
                    ProcessDataType type = ((ProcessDataSet)dataSet).getType(p);
                    if (!record.hasData(type)) continue;
                    builder.setLength(0);
                    builder.append(OUTPUT_FORMAT.format(new Date(time)));
                    builder.append(dataSet.getHostname());
                    builder.append('-');
                    builder.append(p.getName());
                    builder.append('-');
                    if (p.getId() == -1) {
                        builder.append("ALL");
                    } else {
                        builder.append(Integer.toString(p.getId()));
                    }
                    builder.append(',');
                    builder.append(record.getData(type, "%CPU"));
                    printWriter.println(builder);
                }
            }
        }
        printWriter.close();
        System.out.println("Complete");
    }

    private static void createCommandsFile(String outputDir, String baseName, NMONVisualizerCmdLine app) throws IOException {
        ArrayList<ProcessDataSet> dataSets = new ArrayList<ProcessDataSet>(app.getDataSetCount());
        for (DataSet dataSet : app.getDataSets()) {
            if (!(dataSet instanceof ProcessDataSet)) continue;
            dataSets.add((ProcessDataSet)dataSet);
        }
        String outputFile = outputDir + '/' + baseName + "_commands.csv";
        System.out.print("Writing command data to CSV file to " + outputFile + "... ");
        System.out.flush();
        PrintWriter printWriter = new PrintWriter(new FileWriter(outputFile));
        StringBuilder builder = new StringBuilder(512);
        builder.append("Host,PID,Command,Command Line");
        printWriter.println(builder);
        for (ProcessDataSet data : dataSets) {
            for (Process p : data.getProcesses()) {
                if (p.getId() == -1) continue;
                builder.setLength(0);
                builder.append(data.getHostname());
                builder.append(',');
                builder.append(p.getId());
                builder.append(',');
                builder.append(p.getName());
                builder.append(',');
                builder.append(p.getCommandLine());
                printWriter.println(builder);
            }
        }
        printWriter.close();
        System.out.println("Complete");
    }

    @Override
    public void dataAdded(DataSet data) {
        this.timesMonitored.addAll(data.getTimes());
    }

    @Override
    public void dataRemoved(DataSet data) {
    }

    @Override
    public void dataChanged(DataSet data) {
    }

    @Override
    public void dataCleared() {
    }
}

