/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon;

import com.ibm.nmon.NMONVisualizerApp;
import com.ibm.nmon.chart.definition.BaseChartDefinition;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.ProcessDataSet;
import com.ibm.nmon.data.SystemDataSet;
import com.ibm.nmon.file.CombinedFileFilter;
import com.ibm.nmon.gui.chart.ChartFactory;
import com.ibm.nmon.gui.chart.data.DataTupleDataset;
import com.ibm.nmon.interval.Interval;
import com.ibm.nmon.report.ReportCache;
import com.ibm.nmon.util.CSVWriter;
import com.ibm.nmon.util.FileHelper;
import com.ibm.nmon.util.GranularityHelper;
import com.ibm.nmon.util.ParserLog;
import com.ibm.nmon.util.TimeFormatCache;
import com.ibm.nmon.util.TimeHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;

public final class ReportGenerator
extends NMONVisualizerApp {
    private static final SimpleDateFormat FILE_TIME_FORMAT = new SimpleDateFormat("HHmmss");
    private final GranularityHelper granularityHelper;
    private final ChartFactory factory = new ChartFactory(this);
    private final ReportCache cache = new ReportCache();
    private final List<String> customSummaryCharts;
    private final List<String> customDataCharts;
    private final List<String> multiplexedFieldCharts;
    private final List<String> multiplexedTypeCharts;
    private File outputDirectory;
    private boolean writeChartData = false;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("no path(s) to parse specified");
            return;
        }
        System.setProperty("java.awt.headless", "true");
        try {
            LogManager.getLogManager().readConfiguration(ReportGenerator.class.getResourceAsStream("/cmdline.logging.properties"));
        }
        catch (IOException ioe) {
            System.err.println("cannot initialize logging, will output to System.out");
            ioe.printStackTrace();
        }
        ArrayList<String> paths = new ArrayList<String>();
        ArrayList<String> customDataCharts = new ArrayList<String>();
        ArrayList<String> customSummaryCharts = new ArrayList<String>();
        ArrayList<String> multiplexedFieldCharts = new ArrayList<String>();
        ArrayList<String> multiplexedTypeCharts = new ArrayList<String>();
        String intervalsFile = "";
        boolean summaryCharts = true;
        boolean dataSetCharts = true;
        long startTime = Interval.DEFAULT.getStart();
        long endTime = Interval.DEFAULT.getEnd();
        boolean writeRawData = false;
        boolean writeChartData = false;
        block16: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            char c = arg.charAt(0);
            if (c == '-') {
                block17: for (int j = 1; j < arg.length(); ++j) {
                    c = arg.charAt(j);
                    switch (c) {
                        case 's': {
                            try {
                                startTime = ReportGenerator.parseTime(args, ++i, 's');
                                continue block16;
                            }
                            catch (IllegalArgumentException iae) {
                                System.err.println(iae.getMessage());
                                return;
                            }
                        }
                        case 'e': {
                            try {
                                endTime = ReportGenerator.parseTime(args, ++i, 'e');
                                continue block16;
                            }
                            catch (IllegalArgumentException iae) {
                                System.err.println(iae.getMessage());
                                return;
                            }
                        }
                        case 'd': {
                            if (++i > args.length) {
                                System.err.println("file must be specified for -d");
                                return;
                            }
                            customDataCharts.add(args[i]);
                            continue block16;
                        }
                        case 'a': {
                            if (++i > args.length) {
                                System.err.println("file must be specified for -a");
                                return;
                            }
                            customSummaryCharts.add(args[i]);
                            continue block16;
                        }
                        case 'i': {
                            if (++i > args.length) {
                                System.err.println("file must be specified for -s");
                                return;
                            }
                            intervalsFile = args[i];
                            continue block16;
                        }
                        case '-': {
                            if (j == 1) {
                                String param = arg.substring(2);
                                if ("nodata".equals(param)) {
                                    dataSetCharts = false;
                                    continue block16;
                                }
                                if ("nosummary".equals(param)) {
                                    summaryCharts = false;
                                    continue block16;
                                }
                                if ("mf".equals(param)) {
                                    if (++i > args.length) {
                                        System.err.println("file must be specified for --mf");
                                        return;
                                    }
                                    multiplexedFieldCharts.add(args[i]);
                                    continue block16;
                                }
                                if ("mt".equals(param)) {
                                    if (++i > args.length) {
                                        System.err.println("file must be specified for --mt");
                                        return;
                                    }
                                    multiplexedTypeCharts.add(args[i]);
                                    continue block16;
                                }
                                if ("rawdata".equals(param)) {
                                    writeRawData = true;
                                    continue block16;
                                }
                                if ("chartdata".equals(param)) {
                                    writeChartData = true;
                                    continue block16;
                                }
                                System.err.println("ignoring unknown parameter --" + param);
                                continue block16;
                            }
                            System.err.println("ignoring misplaced dash in " + arg);
                            continue block17;
                        }
                        default: {
                            System.err.println("ignoring unknown parameter -" + c);
                        }
                    }
                }
                continue;
            }
            paths.add(arg);
        }
        boolean createCharts = true;
        if (!summaryCharts && !dataSetCharts && customDataCharts.isEmpty() && customSummaryCharts.isEmpty()) {
            System.out.println("--nodata, --nosummary were specifed and no custom chart definitions (-d or -a) were given: no charts will be output");
            createCharts = false;
        }
        if (paths.isEmpty()) {
            System.err.println("no path(s) to parse specified");
            return;
        }
        ArrayList<String> filesToParse = new ArrayList<String>();
        for (String path : paths) {
            File pathToParse = new File(path);
            FileHelper.recurseDirectories(Collections.singletonList(pathToParse), (FileFilter)CombinedFileFilter.getInstance(false), filesToParse);
            if (!filesToParse.isEmpty()) continue;
            System.err.println('\'' + pathToParse.toString() + "' contains no parsable files");
            return;
        }
        ReportGenerator generator = new ReportGenerator(customSummaryCharts, customDataCharts, multiplexedFieldCharts, multiplexedTypeCharts);
        File outputDirectory = null;
        outputDirectory = paths.size() == 1 ? new File((String)paths.get(0)) : new File(System.getProperty("user.dir"));
        generator.outputDirectory = outputDirectory.isDirectory() ? outputDirectory : outputDirectory.getParentFile();
        generator.writeChartData = writeChartData;
        generator.parse(filesToParse);
        if (!"".equals(intervalsFile)) {
            try {
                generator.getIntervalManager().loadFromFile(new File(intervalsFile), 0L);
            }
            catch (IOException ioe) {
                System.err.println("cannot load intervals from '" + intervalsFile + "'");
                ioe.printStackTrace();
            }
        }
        generator.createIntervalIfNecessary(startTime, endTime);
        if (createCharts) {
            if (generator.getIntervalManager().getIntervalCount() != 0) {
                for (Interval interval : generator.getIntervalManager().getIntervals()) {
                    generator.createReport(interval, summaryCharts, dataSetCharts);
                }
            } else {
                generator.createReport(Interval.DEFAULT, summaryCharts, dataSetCharts);
            }
            System.out.println("Charts complete!");
        }
        if (writeRawData) {
            if (createCharts) {
                System.out.println();
            }
            if (generator.getIntervalManager().getIntervalCount() != 0) {
                for (Interval interval : generator.getIntervalManager().getIntervals()) {
                    generator.writeRawData(interval);
                }
            } else {
                generator.writeRawData(Interval.DEFAULT);
            }
            System.out.println("Raw data complete!");
        }
    }

    private static long parseTime(String[] args, int index, char param) {
        if (index > args.length) {
            throw new IllegalArgumentException("time must be specified for -" + param);
        }
        try {
            return TimeHelper.TIMESTAMP_FORMAT_ISO.parse(args[index]).getTime();
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("time specified for -" + param + " (" + args[index] + ") is not valid");
        }
    }

    private ReportGenerator(List<String> customSummaryCharts, List<String> customDataCharts, List<String> multiplexedFieldCharts, List<String> multiplexedTypeCharts) {
        this.granularityHelper = new GranularityHelper(this);
        this.granularityHelper.setAutomatic(true);
        this.customSummaryCharts = customSummaryCharts;
        this.customDataCharts = customDataCharts;
        this.multiplexedFieldCharts = multiplexedFieldCharts;
        this.multiplexedTypeCharts = multiplexedTypeCharts;
        for (String file : customSummaryCharts) {
            this.parseChartDefinition(file);
        }
        for (String file : customDataCharts) {
            this.parseChartDefinition(file);
        }
        for (String file : multiplexedFieldCharts) {
            this.parseChartDefinition(file);
        }
        for (String file : multiplexedTypeCharts) {
            this.parseChartDefinition(file);
        }
    }

    private void parse(List<String> filesToParse) {
        ParserLog log = ParserLog.getInstance();
        Logger.getLogger(log.getLogger().getName()).setUseParentHandlers(false);
        LinkedHashMap<String, String> errors = new LinkedHashMap<String, String>();
        System.out.println("Parsing NMON files...");
        for (String fileToParse : filesToParse) {
            System.out.print("\t" + fileToParse + "... ");
            System.out.flush();
            log.setCurrentFilename(fileToParse);
            try {
                this.parse(fileToParse, this.getDisplayTimeZone());
                if (log.hasData()) {
                    System.out.println("Complete with errors!");
                } else {
                    System.out.println("Complete");
                }
            }
            catch (Exception e) {
                log.getLogger().error("could not parse " + fileToParse, (Throwable)e);
                System.out.println("Complete with errors!");
            }
            if (!log.hasData()) continue;
            errors.put(log.getCurrentFilename(), log.getMessages());
        }
        System.out.println("Parsing complete!");
        if (!errors.isEmpty()) {
            File errorFile = new File(this.outputDirectory, "ReportGenerator_" + new SimpleDateFormat("yyyyMMdd_HHmmss").format(System.currentTimeMillis()) + ".log");
            PrintStream out = null;
            try {
                out = new PrintStream(new FileOutputStream(errorFile));
            }
            catch (IOException io) {
                System.err.println("could not create error log file '" + errorFile.getAbsolutePath() + "'; no output will be logged");
                return;
            }
            for (String filename : errors.keySet()) {
                out.print(filename);
                out.println(':');
                out.println((String)errors.get(filename));
            }
            out.close();
            System.out.println();
            System.out.println("Errors written to " + errorFile);
        }
        Logger.getLogger(ParserLog.getInstance().getLogger().getName()).setUseParentHandlers(true);
    }

    private void parseChartDefinition(String definitionFile) {
        try {
            this.cache.addReport(definitionFile, definitionFile);
        }
        catch (IOException ioe) {
            System.err.println("cannot parse chart definition " + definitionFile);
            ioe.printStackTrace();
        }
    }

    private void createIntervalIfNecessary(long startTime, long endTime) {
        if (startTime == Interval.DEFAULT.getStart()) {
            startTime = this.getMinSystemTime();
        }
        if (endTime == Interval.DEFAULT.getEnd()) {
            endTime = this.getMaxSystemTime();
        }
        Interval toChart = null;
        if (startTime == this.getMinSystemTime() && endTime == this.getMaxSystemTime()) {
            toChart = Interval.DEFAULT;
        } else {
            try {
                toChart = new Interval(startTime, endTime);
            }
            catch (Exception e) {
                System.err.println("invalid start and end times: " + e.getMessage());
                System.err.println("The default interval will be used instead");
                toChart = Interval.DEFAULT;
            }
        }
        this.getIntervalManager().addInterval(toChart);
    }

    private void createReport(Interval interval, boolean summaryCharts, boolean dataSetCharts) {
        System.out.println();
        this.getIntervalManager().setCurrentInterval(interval);
        System.out.println("Charting interval " + TimeFormatCache.formatInterval(interval));
        File chartsDirectory = this.createSubdirectory("charts", interval);
        int chartsCreated = 0;
        System.out.println("Writing charts to " + chartsDirectory.getAbsolutePath());
        if (summaryCharts) {
            chartsCreated += this.createSummaryCharts("Creating summary charts", "summary", chartsDirectory);
        }
        if (dataSetCharts) {
            for (DataSet dataSet : this.getDataSets()) {
                chartsCreated += this.createDataSetCharts("Creating charts for " + dataSet.getHostname(), "dataset", chartsDirectory, dataSet);
            }
        }
        for (String string : this.customSummaryCharts) {
            chartsCreated += this.createSummaryCharts("Creating  charts for " + string, string, chartsDirectory);
        }
        for (String string : this.customDataCharts) {
            for (DataSet dataSet : this.getDataSets()) {
                chartsCreated += this.createDataSetCharts("Creating charts for " + string + " (" + dataSet.getHostname() + ")", string, chartsDirectory, dataSet);
            }
        }
        for (String string : this.multiplexedFieldCharts) {
            for (DataSet dataSet : this.getDataSets()) {
                chartsCreated += this.multiplexChartsAcrossFields("Multiplexing charts for " + string + " (" + dataSet.getHostname() + ") across " + "fields", string, chartsDirectory, dataSet);
            }
        }
        for (String string : this.multiplexedTypeCharts) {
            for (DataSet dataSet : this.getDataSets()) {
                chartsCreated += this.multiplexChartsAcrossTypes("Multiplexing charts for " + string + " (" + dataSet.getHostname() + ") across " + "types", string, chartsDirectory, dataSet);
            }
        }
        if (chartsCreated == 0) {
            chartsDirectory.delete();
        }
    }

    private int createSummaryCharts(String message, String key, File chartsDirectory) {
        int chartsCreated = 0;
        Iterable<SystemDataSet> dataSets = this.getDataSets();
        List<BaseChartDefinition> report = this.cache.getReport(key, dataSets);
        if (!report.isEmpty()) {
            System.out.print("\t" + message + " ");
            System.out.flush();
            for (BaseChartDefinition definition : report) {
                if (!this.saveChart(definition, dataSets, chartsDirectory)) continue;
                ++chartsCreated;
            }
            System.out.println(" Complete (" + chartsCreated + '/' + report.size() + ")");
        }
        return chartsCreated;
    }

    private int createDataSetCharts(String message, String key, File chartsDirectory, DataSet data) {
        int chartsCreated = 0;
        List<DataSet> dataSets = Collections.singletonList(data);
        List<BaseChartDefinition> report = this.cache.getReport(key, dataSets);
        if (!report.isEmpty()) {
            System.out.print("\t" + message + " ");
            System.out.flush();
            File datasetDirectory = new File(chartsDirectory, data.getHostname());
            datasetDirectory.mkdir();
            for (BaseChartDefinition definition : report) {
                if (!this.saveChart(definition, dataSets, datasetDirectory)) continue;
                ++chartsCreated;
            }
            if (chartsCreated == 0) {
                datasetDirectory.delete();
            }
            System.out.println(" Complete (" + chartsCreated + '/' + report.size() + ")");
        }
        return chartsCreated;
    }

    private int multiplexChartsAcrossTypes(String message, String key, File chartsDirectory, DataSet data) {
        int chartsCreated = 0;
        List<BaseChartDefinition> report = this.cache.multiplexChartsAcrossTypes(key, data, true);
        if (!report.isEmpty()) {
            System.out.print("\t" + message + " ");
            System.out.flush();
            List<DataSet> dataSets = Collections.singletonList(data);
            File datasetDirectory = new File(chartsDirectory, data.getHostname());
            datasetDirectory.mkdir();
            for (BaseChartDefinition definition : report) {
                if (!this.saveChart(definition, dataSets, datasetDirectory)) continue;
                ++chartsCreated;
            }
            if (chartsCreated == 0) {
                datasetDirectory.delete();
            }
            System.out.println(" Complete (" + chartsCreated + '/' + report.size() + ")");
        }
        return chartsCreated;
    }

    private int multiplexChartsAcrossFields(String message, String key, File chartsDirectory, DataSet data) {
        int chartsCreated = 0;
        List<BaseChartDefinition> report = this.cache.multiplexChartsAcrossFields(key, data, true);
        if (!report.isEmpty()) {
            System.out.print("\t" + message + " ");
            System.out.flush();
            List<DataSet> dataSets = Collections.singletonList(data);
            File datasetDirectory = new File(chartsDirectory, data.getHostname());
            datasetDirectory.mkdir();
            for (BaseChartDefinition definition : report) {
                if (!this.saveChart(definition, dataSets, datasetDirectory)) continue;
                ++chartsCreated;
            }
            if (chartsCreated == 0) {
                datasetDirectory.delete();
            }
            System.out.println(" Complete (" + chartsCreated + '/' + report.size() + ")");
        }
        return chartsCreated;
    }

    private boolean saveChart(BaseChartDefinition definition, Iterable<? extends DataSet> dataSets, File saveDirectory) {
        JFreeChart chart = this.factory.createChart(definition, dataSets);
        if (this.chartHasData(chart)) {
            File chartFile = new File(saveDirectory, definition.getShortName() + ".png");
            try {
                ChartUtilities.saveChartAsPNG((File)chartFile, (JFreeChart)chart, (int)definition.getWidth(), (int)definition.getHeight());
            }
            catch (IOException ioe) {
                System.err.println("cannot create chart " + chartFile.getName());
            }
            if (this.writeChartData) {
                this.writeChartData(chart, definition, saveDirectory);
            }
            System.out.print('.');
            System.out.flush();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRawData(Interval interval) {
        System.out.println("Writing data for interval " + TimeFormatCache.formatInterval(interval));
        File rawDirectory = this.createSubdirectory("rawdata", interval);
        System.out.println("Writing CSV files to " + rawDirectory.getAbsolutePath());
        for (DataSet dataSet : this.getDataSets()) {
            ProcessDataSet processData;
            if (dataSet.getRecordCount(interval) == 0) {
                System.out.println("\tNo data for " + dataSet.getHostname() + " during the interval");
                continue;
            }
            System.out.print("\tWriting CSV for " + dataSet.getHostname() + " ... ");
            System.out.flush();
            File dataFile = new File(rawDirectory, dataSet.getHostname() + ".csv");
            FileWriter writer = null;
            try {
                writer = new FileWriter(dataFile);
                CSVWriter.write(dataSet, interval, writer);
                System.out.println("Complete");
            }
            catch (IOException ioe) {
                System.err.println("could not output raw data to " + dataFile.getName());
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException ioe) {}
                }
            }
            if (!(dataSet instanceof ProcessDataSet) || (processData = (ProcessDataSet)dataSet).getProcessCount() == 0) continue;
            dataFile = new File(rawDirectory, dataSet.getHostname() + "_processes" + ".csv");
            writer = null;
            try {
                writer = new FileWriter(dataFile);
                CSVWriter.writeProcesses(dataSet, writer);
                System.out.println("Complete");
            }
            catch (IOException ioe) {
                System.err.println("could not output raw data to " + dataFile.getName());
            }
            finally {
                if (writer == null) continue;
                try {
                    writer.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeChartData(JFreeChart chart, BaseChartDefinition definition, File saveDirectory) {
        File csvFile = new File(saveDirectory, definition.getShortName() + ".csv");
        FileWriter writer = null;
        Plot plot = chart.getPlot();
        DataTupleDataset dataset = null;
        if (plot instanceof CategoryPlot) {
            CategoryPlot cPlot = (CategoryPlot)plot;
            dataset = (DataTupleDataset)cPlot.getDataset();
        } else if (plot instanceof XYPlot) {
            XYPlot xyPlot = (XYPlot)plot;
            dataset = (DataTupleDataset)xyPlot.getDataset();
        } else {
            System.err.println("unknown plot type " + plot.getClass() + " for chart " + chart.getTitle());
        }
        if (dataset != null) {
            try {
                writer = new FileWriter(csvFile);
                CSVWriter.write(dataset, (Writer)writer);
            }
            catch (IOException ioe) {
                System.err.println("could not output raw data to " + csvFile.getName());
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }

    private File createSubdirectory(String subDirName, Interval interval) {
        File toCreate = null;
        toCreate = this.getIntervalManager().getIntervalCount() <= 1 ? new File(this.outputDirectory, subDirName) : ("".equals(interval.getName()) ? new File(this.outputDirectory, subDirName + '/' + FILE_TIME_FORMAT.format(new Date(interval.getStart())) + '-' + FILE_TIME_FORMAT.format(new Date(interval.getEnd()))) : new File(this.outputDirectory, subDirName + '/' + interval.getName()));
        toCreate.mkdirs();
        return toCreate;
    }

    private boolean chartHasData(JFreeChart chart) {
        boolean hasData;
        block8: {
            hasData = false;
            Plot plot = chart.getPlot();
            if (plot instanceof CategoryPlot) {
                CategoryPlot cPlot = (CategoryPlot)plot;
                for (int i = 0; i < cPlot.getDatasetCount(); ++i) {
                    for (int j = 0; j < cPlot.getDataset(i).getRowCount(); ++j) {
                        for (int k = 0; k < cPlot.getDataset(i).getColumnCount(); ++k) {
                            Number value = cPlot.getDataset(0).getValue(j, k);
                            if (value == null || Double.isNaN(value.doubleValue())) continue;
                            hasData = true;
                            break block8;
                        }
                    }
                }
            } else if (plot instanceof XYPlot) {
                XYPlot xyPlot = (XYPlot)plot;
                for (int i = 0; i < xyPlot.getDatasetCount(); ++i) {
                    if (xyPlot.getDataset(i).getSeriesCount() <= 0) continue;
                    hasData = true;
                    break;
                }
            } else {
                System.err.println("unknown plot type " + plot.getClass() + " for chart " + chart.getTitle());
            }
        }
        return hasData;
    }

    @Override
    public void currentIntervalChanged(Interval interval) {
        super.currentIntervalChanged(interval);
        this.granularityHelper.recalculate();
        this.factory.setInterval(interval);
        this.factory.setGranularity(this.granularityHelper.getGranularity());
    }
}

