/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.analysis;

import com.ibm.nmon.data.DataRecord;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.ProcessDataType;
import com.ibm.nmon.interval.Interval;
import com.ibm.nmon.util.TimeFormatCache;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnalysisRecord {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalysisRecord.class);
    private final DataSet data;
    private final Map<String, SoftReference<AnalysisHolder>> values = new HashMap<String, SoftReference<AnalysisHolder>>();
    private Interval interval;
    private int granularity = 60000;

    public AnalysisRecord(DataSet data) {
        this.data = data;
        this.interval = Interval.DEFAULT;
    }

    public DataSet getDataSet() {
        return this.data;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public void setInterval(Interval interval) {
        if (!this.interval.equals(interval)) {
            this.interval = interval;
            this.values.clear();
        }
    }

    public void setGranularity(int granularity) {
        if (granularity < 1) {
            throw new IllegalArgumentException("granularity must be greater than 0");
        }
        if (granularity != this.granularity) {
            this.granularity = granularity;
            this.values.clear();
        }
    }

    public double getAverage(DataType type, String fieldName) {
        return this.analyzeIfNecessary((DataType)type, (String)fieldName).average;
    }

    public double getMinimum(DataType type, String fieldName) {
        return this.analyzeIfNecessary((DataType)type, (String)fieldName).minimum;
    }

    public double getMaximum(DataType type, String fieldName) {
        return this.analyzeIfNecessary((DataType)type, (String)fieldName).maximum;
    }

    public double getGranularityMaximum(DataType type, String fieldName) {
        return this.analyzeIfNecessary((DataType)type, (String)fieldName).granularityMaximum;
    }

    public double getMedian(DataType type, String fieldName) {
        return this.analyzeIfNecessary((DataType)type, (String)fieldName).median;
    }

    public double get95thPercentile(DataType type, String fieldName) {
        return this.analyzeIfNecessary((DataType)type, (String)fieldName).percentile95;
    }

    public double get99thPercentile(DataType type, String fieldName) {
        return this.analyzeIfNecessary((DataType)type, (String)fieldName).percentile99;
    }

    public double getStandardDeviation(DataType type, String fieldName) {
        return this.analyzeIfNecessary((DataType)type, (String)fieldName).standardDeviation;
    }

    public double getSum(DataType type, String fieldName) {
        return this.analyzeIfNecessary((DataType)type, (String)fieldName).sum;
    }

    public int getCount(DataType type, String fieldName) {
        return this.analyzeIfNecessary((DataType)type, (String)fieldName).count;
    }

    private AnalysisHolder analyzeIfNecessary(DataType type, String fieldName) {
        if (type == null) {
            throw new IllegalArgumentException("cannot analyze null type");
        }
        if (fieldName == null || "".equals(fieldName)) {
            throw new IllegalArgumentException("cannot analyze null field");
        }
        String key = type.getKey(fieldName);
        SoftReference<AnalysisHolder> holderRef = this.values.get(key);
        AnalysisHolder holder = null;
        if (holderRef != null && (holder = holderRef.get()) != null) {
            return holder;
        }
        holder = new AnalysisHolder();
        this.values.put(key, new SoftReference<AnalysisHolder>(holder));
        long startT = System.nanoTime();
        DataType typeToAnalyze = this.data.getType(type.getId());
        if (typeToAnalyze != null && typeToAnalyze.hasField(fieldName)) {
            ArrayList<Double> allValues = new ArrayList<Double>(this.data.getRecordCount());
            long lastGranularityTime = Math.max(this.interval.getStart(), this.data.getStartTime());
            int countSinceLastGranularity = 0;
            double granularityTotal = 0.0;
            boolean isProcess = type.getClass() == ProcessDataType.class;
            for (DataRecord dataRecord : this.data.getRecords(this.interval)) {
                double value = Double.NaN;
                if (isProcess) {
                    if (dataRecord.hasData(typeToAnalyze)) {
                        value = dataRecord.getData(typeToAnalyze, fieldName);
                    }
                    if (Double.isNaN(value)) {
                        value = 0.0;
                    }
                } else {
                    if (dataRecord.hasData(typeToAnalyze)) {
                        value = dataRecord.getData(typeToAnalyze, fieldName);
                    }
                    if (Double.isNaN(value)) continue;
                }
                holder.sum += value;
                if (value > holder.maximum) {
                    holder.maximum = value;
                }
                if (value < holder.minimum) {
                    holder.minimum = value;
                }
                allValues.add(value);
                ++countSinceLastGranularity;
                granularityTotal += value;
                if (dataRecord.getTime() - lastGranularityTime < (long)this.granularity) continue;
                double peakAverage = granularityTotal / (double)countSinceLastGranularity;
                if (peakAverage > holder.granularityMaximum) {
                    holder.granularityMaximum = peakAverage;
                }
                countSinceLastGranularity = 0;
                granularityTotal = 0.0;
                lastGranularityTime = dataRecord.getTime();
            }
            if (allValues.size() > 0) {
                holder.count = allValues.size();
                holder.average = holder.sum / (double)holder.count;
                Collections.sort(allValues);
                holder.median = AnalysisRecord.calculatePercentile(0.5, allValues);
                holder.percentile95 = AnalysisRecord.calculatePercentile(0.95, allValues);
                holder.percentile99 = AnalysisRecord.calculatePercentile(0.99, allValues);
                double sumSqDiffs = 0.0;
                Iterator i$ = allValues.iterator();
                while (i$.hasNext()) {
                    double value = (Double)i$.next();
                    sumSqDiffs += Math.pow(value - holder.average, 2.0);
                }
                holder.standardDeviation = Math.sqrt(sumSqDiffs / (double)holder.count);
            } else {
                holder.maximum = Double.NaN;
                holder.minimum = Double.NaN;
                holder.granularityMaximum = Double.NaN;
            }
        } else {
            holder.maximum = Double.NaN;
            holder.minimum = Double.NaN;
            holder.granularityMaximum = Double.NaN;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}: {}-{} analyzed for {} in {}ms ", new Object[]{this.data, type, fieldName, TimeFormatCache.formatInterval(this.interval), (double)(System.nanoTime() - startT) / 1000000.0});
        }
        return holder;
    }

    public static double calculatePercentile(double percentile, List<Double> allValues) {
        int idx;
        double n = (double)allValues.size() * percentile;
        if (n - (double)(idx = (int)n) == 0.0) {
            return (allValues.get(idx) + allValues.get(idx - 1)) / 2.0;
        }
        return allValues.get(idx);
    }

    private static final class AnalysisHolder {
        int count = 0;
        double sum = 0.0;
        double average = Double.NaN;
        double granularityMaximum = Double.MIN_VALUE;
        double median = Double.NaN;
        double percentile95 = Double.NaN;
        double percentile99 = Double.NaN;
        double minimum = Double.MAX_VALUE;
        double maximum = Double.MIN_VALUE;
        double standardDeviation = Double.NaN;

        private AnalysisHolder() {
        }
    }
}

