/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.analysis;

import com.ibm.nmon.analysis.AnalysisSetListener;
import com.ibm.nmon.data.DataType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public final class AnalysisSet {
    private final Map<String, DataType> types = new HashMap<String, DataType>();
    private final Map<String, String> fields = new HashMap<String, String>();
    private final List<AnalysisSetListener> listeners = new CopyOnWriteArrayList<AnalysisSetListener>();

    public void addData(DataType type) {
        HashSet<String> added = new HashSet<String>(type.getFieldCount());
        for (String field : type.getFields()) {
            String key = type.getKey(field);
            if (this.types.put(key, type) != null) continue;
            this.fields.put(key, field);
            added.add(key);
        }
        if (added.size() == type.getFieldCount()) {
            for (AnalysisSetListener listener : this.listeners) {
                listener.analysisAdded(type);
            }
        } else {
            for (String key : added) {
                for (AnalysisSetListener listener : this.listeners) {
                    listener.analysisAdded(this.types.get(key), this.fields.get(key));
                }
            }
        }
    }

    public void addData(DataType type, String field) {
        String key = type.getKey(field);
        if (this.types.put(key, type) == null) {
            this.fields.put(key, field);
            for (AnalysisSetListener listener : this.listeners) {
                listener.analysisAdded(type, field);
            }
        }
    }

    public void removeData(String key) {
        DataType type = this.types.remove(key);
        String field = this.fields.remove(key);
        if (type != null && field != null) {
            for (AnalysisSetListener listener : this.listeners) {
                listener.analysisRemoved(type, field);
            }
        }
    }

    public void clearData() {
        this.types.clear();
        this.fields.clear();
        for (AnalysisSetListener listener : this.listeners) {
            listener.analysisCleared();
        }
    }

    public DataType getType(String key) {
        return this.types.get(key);
    }

    public String getField(String key) {
        return this.fields.get(key);
    }

    public Iterable<String> getKeys() {
        return Collections.unmodifiableSet(this.types.keySet());
    }

    public int size() {
        return this.types.size();
    }

    public void addListener(AnalysisSetListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(AnalysisSetListener listener) {
        this.listeners.remove(listener);
    }
}

