/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.analysis;

import com.ibm.nmon.analysis.AnalysisRecord;
import com.ibm.nmon.data.DataType;

public enum Statistic {
    AVERAGE("Average"){

        @Override
        public double getValue(AnalysisRecord record, DataType type, String fieldName) {
            return record.getAverage(type, fieldName);
        }
    }
    ,
    MINIMUM("Minimum"){

        @Override
        public double getValue(AnalysisRecord record, DataType type, String fieldName) {
            return record.getMinimum(type, fieldName);
        }
    }
    ,
    MAXIMUM("Maximum"){

        @Override
        public double getValue(AnalysisRecord record, DataType type, String fieldName) {
            return record.getMaximum(type, fieldName);
        }
    }
    ,
    GRANULARITY_MAXIMUM("Granularity Max"){

        @Override
        public double getValue(AnalysisRecord record, DataType type, String fieldName) {
            return record.getGranularityMaximum(type, fieldName);
        }

        @Override
        public String getName(int granularity) {
            int minutes = (granularity /= 1000) / 60;
            int seconds = granularity % 60;
            String title = null;
            title = minutes == 0 ? seconds + "s Peak" : minutes + ":" + (seconds < 10 ? "0" : "") + seconds + " Peak (mm:ss)";
            return title;
        }
    }
    ,
    STD_DEV("Std Dev"){

        @Override
        public double getValue(AnalysisRecord record, DataType type, String fieldName) {
            return record.getStandardDeviation(type, fieldName);
        }
    }
    ,
    MEDIAN("Median"){

        @Override
        public double getValue(AnalysisRecord record, DataType type, String fieldName) {
            return record.getMedian(type, fieldName);
        }
    }
    ,
    PERCENTILE_95("95th Percentile"){

        @Override
        public double getValue(AnalysisRecord record, DataType type, String fieldName) {
            return record.get95thPercentile(type, fieldName);
        }
    }
    ,
    PERCENTILE_99("99th Percentile"){

        @Override
        public double getValue(AnalysisRecord record, DataType type, String fieldName) {
            return record.get99thPercentile(type, fieldName);
        }
    }
    ,
    SUM("Sum"){

        @Override
        public double getValue(AnalysisRecord record, DataType type, String fieldName) {
            return record.getSum(type, fieldName);
        }
    }
    ,
    COUNT("Count"){

        @Override
        public double getValue(AnalysisRecord record, DataType type, String fieldName) {
            return record.getCount(type, fieldName);
        }
    };

    private final String name;

    private Statistic(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public abstract double getValue(AnalysisRecord var1, DataType var2, String var3);

    public String getName(int granularity) {
        return this.name;
    }
}

