/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.chart.definition;

import com.ibm.nmon.data.definition.DataDefinition;
import com.ibm.nmon.data.definition.NamingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BaseChartDefinition
implements Cloneable {
    private String shortName;
    private String title;
    private int width;
    private int height;
    private final List<DataDefinition> data;
    private NamingMode subtitleNamingMode = NamingMode.HOST;

    protected BaseChartDefinition(String shortName, String title) {
        this.setShortName(shortName);
        this.setTitle(title);
        this.width = 960;
        this.height = 540;
        this.data = new ArrayList<DataDefinition>(3);
    }

    protected BaseChartDefinition(BaseChartDefinition copy, boolean copyData) {
        this.shortName = copy.shortName;
        this.title = copy.title;
        this.width = copy.width;
        this.height = copy.height;
        this.subtitleNamingMode = copy.subtitleNamingMode;
        this.data = copyData ? new ArrayList<DataDefinition>(copy.data) : new ArrayList<DataDefinition>(3);
    }

    public final String getShortName() {
        return this.shortName;
    }

    public final void setShortName(String shortName) {
        this.shortName = shortName == null ? "" : shortName;
    }

    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(String title) {
        this.title = title == null ? "" : title;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        if (this.height < 1) {
            throw new IllegalArgumentException("heightmust be greater than 0");
        }
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        if (height < 1) {
            throw new IllegalArgumentException("heightmust be greater than 0");
        }
        this.height = height;
    }

    public final NamingMode getSubtitleNamingMode() {
        return this.subtitleNamingMode;
    }

    public final void setSubtitleNamingMode(NamingMode subtitleNamingMode) {
        this.subtitleNamingMode = subtitleNamingMode == null ? NamingMode.NONE : subtitleNamingMode;
    }

    public final void addData(DataDefinition dataDefinition) {
        this.data.add(dataDefinition);
    }

    public final Iterable<DataDefinition> getData() {
        return Collections.unmodifiableList(this.data);
    }

    public final String toString() {
        if ("".equals(this.shortName)) {
            if ("".equals(this.title)) {
                return "<untitled chart>";
            }
            return this.title;
        }
        return this.shortName;
    }
}

