/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.chart.definition;

import com.ibm.nmon.analysis.Statistic;
import com.ibm.nmon.chart.definition.BarChartDefinition;
import com.ibm.nmon.chart.definition.BaseChartDefinition;
import com.ibm.nmon.chart.definition.HistogramChartDefinition;
import com.ibm.nmon.chart.definition.IntervalChartDefinition;
import com.ibm.nmon.chart.definition.LineChartDefinition;
import com.ibm.nmon.chart.definition.YAxisChartDefinition;
import com.ibm.nmon.data.definition.DefaultDataDefinition;
import com.ibm.nmon.data.definition.NamingMode;
import com.ibm.nmon.data.matcher.DiskMatcher;
import com.ibm.nmon.data.matcher.ExactFieldMatcher;
import com.ibm.nmon.data.matcher.ExactHostMatcher;
import com.ibm.nmon.data.matcher.ExactTypeMatcher;
import com.ibm.nmon.data.matcher.FieldMatcher;
import com.ibm.nmon.data.matcher.HostMatcher;
import com.ibm.nmon.data.matcher.OSMatcher;
import com.ibm.nmon.data.matcher.PartitionMatcher;
import com.ibm.nmon.data.matcher.ProcessMatcher;
import com.ibm.nmon.data.matcher.RegexFieldMatcher;
import com.ibm.nmon.data.matcher.RegexHostMatcher;
import com.ibm.nmon.data.matcher.RegexTypeMatcher;
import com.ibm.nmon.data.matcher.SetFieldMatcher;
import com.ibm.nmon.data.matcher.TypeMatcher;
import com.ibm.nmon.data.transform.name.NameTransformer;
import com.ibm.nmon.data.transform.name.RegexNameTransformer;
import com.ibm.nmon.data.transform.name.SimpleNameTransformer;
import com.ibm.nmon.parser.BasicXMLParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfree.data.Range;

public final class ChartDefinitionParser
extends BasicXMLParser {
    private final List<BaseChartDefinition> charts = new ArrayList<BaseChartDefinition>();
    private BaseChartDefinition currentChart;
    private HostMatcher hostMatcher;
    private NameTransformer hostTransformer;
    private TypeMatcher typeMatcher;
    private NameTransformer typeTransformer;
    private final List<FieldMatcher> fieldMatchers = new ArrayList<FieldMatcher>(3);
    private final Map<String, SimpleNameTransformer> fieldTransformers = new HashMap<String, SimpleNameTransformer>(3);
    private RegexNameTransformer regexFieldRegexTransformer;
    private boolean inData;
    private Statistic currentStat;
    private final Set<Statistic> markers = new HashSet<Statistic>(3);
    private boolean useSecondaryYAxis;

    public ChartDefinitionParser() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BaseChartDefinition> parseCharts(String filename) throws IOException {
        long start = System.nanoTime();
        try {
            this.parse(filename);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("parse complete for file '{}' in {}ms", (Object)filename, (Object)((double)(System.nanoTime() - start) / 1000000.0));
            }
            if (this.charts.isEmpty()) {
                throw new IOException("chart definition file '" + filename + "' does not appear to have any charts defined");
            }
            List<BaseChartDefinition> list = Collections.unmodifiableList(new ArrayList<BaseChartDefinition>(this.charts));
            return list;
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BaseChartDefinition> parseCharts(InputStream in) throws IOException {
        long start = System.nanoTime();
        this.reset();
        this.parse(in);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Parse complete for input stream '{}' in {}ms", (Object)in, (Object)((double)(System.nanoTime() - start) / 1000000.0));
        }
        if (this.charts.isEmpty()) {
            throw new IOException("chart definition input stream '" + in + "' does not appear to have any charts defined");
        }
        try {
            List<BaseChartDefinition> list = Collections.unmodifiableList(new ArrayList<BaseChartDefinition>(this.charts));
            return list;
        }
        finally {
            this.reset();
        }
    }

    @Override
    protected void startElement(String element, String unparsedAttributes) {
        if ("linechart".equals(element)) {
            this.createLineChart(this.parseAttributes(unparsedAttributes));
        } else if ("intervalchart".equals(element)) {
            this.createIntervalChart(this.parseAttributes(unparsedAttributes));
        } else if ("barchart".equals(element)) {
            this.createBarChart(this.parseAttributes(unparsedAttributes));
        } else if ("histogram".equals(element)) {
            this.createHistogram(this.parseAttributes(unparsedAttributes));
        } else if ("yAxis".equals(element)) {
            if (this.currentChart instanceof YAxisChartDefinition) {
                Map<String, String> attributes = this.parseAttributes(unparsedAttributes);
                ((YAxisChartDefinition)this.currentChart).setUsePercentYAxis(Boolean.valueOf(attributes.get("asPercent")));
                ((YAxisChartDefinition)this.currentChart).setYAxisLabel(attributes.get("label"));
            } else {
                this.logger.warn("ignoring <yAxis> element for chart " + (this.currentChart == null ? this.currentChart : this.currentChart.getShortName()) + " without a Y axis" + " at line {}", (Object)this.getLineNumber());
            }
        } else if ("yAxis2".equals(element)) {
            if (this.currentChart instanceof YAxisChartDefinition) {
                Map<String, String> attributes = this.parseAttributes(unparsedAttributes);
                if (attributes.get("asPercent") != null) {
                    this.logger.warn("ignoring asPercent attribute for <yAxis2> element for chart '" + (this.currentChart == null ? this.currentChart : this.currentChart.getShortName()) + '\'' + " at line {}" + "; secondary axes do not support percentages", (Object)this.getLineNumber());
                }
                if (this.currentChart instanceof BarChartDefinition && ((BarChartDefinition)this.currentChart).isStacked()) {
                    this.logger.warn("ignoring <yAxis2> element for chart " + (this.currentChart == null ? this.currentChart : this.currentChart.getShortName()) + " at line {}" + "; stacked bar charts do not support secondary axes", (Object)this.getLineNumber());
                } else {
                    ((YAxisChartDefinition)this.currentChart).setSecondaryYAxisLabel(attributes.get("label"));
                    ((YAxisChartDefinition)this.currentChart).setHasSecondaryYAxis(true);
                }
            } else {
                this.logger.warn("ignoring <yAxis2> element for chart " + (this.currentChart == null ? this.currentChart : this.currentChart.getShortName()) + " without a Y axis" + " at line {}", (Object)this.getLineNumber());
            }
        } else if ("xAxis".equals(element)) {
            if (this.currentChart instanceof LineChartDefinition) {
                Map<String, String> attributes = this.parseAttributes(unparsedAttributes);
                ((LineChartDefinition)this.currentChart).setXAxisLabel(attributes.get("label"));
            } else if (this.currentChart instanceof BarChartDefinition) {
                Map<String, String> attributes = this.parseAttributes(unparsedAttributes);
                ((BarChartDefinition)this.currentChart).setCategoryAxisLabel(attributes.get("label"));
            } else if (this.currentChart instanceof HistogramChartDefinition) {
                Map<String, String> attributes = this.parseAttributes(unparsedAttributes);
                ((HistogramChartDefinition)this.currentChart).setXAxisLabel(attributes.get("label"));
                String minString = attributes.get("min");
                String maxString = attributes.get("max");
                if (minString != null && maxString == null || maxString != null && minString == null) {
                    this.logger.warn("ignoring <histogram> attributes 'min' and 'max' must both be specified  at line {}, if a defined range is desired", (Object)this.getLineNumber());
                } else {
                    try {
                        ((HistogramChartDefinition)this.currentChart).setXAxisRange(new Range((double)Integer.parseInt(minString), (double)Integer.parseInt(maxString)));
                    }
                    catch (NumberFormatException nfe) {
                        this.logger.warn("ignoring <histogram> attributes 'min' and 'max' with values '{}' and '{}' at line {}, are not a valid numbers", new Object[]{minString, maxString, this.getLineNumber()});
                    }
                    catch (IllegalArgumentException iae) {
                        this.logger.warn("ignoring <histogram> attributes 'min' and 'max' with values '{}' and '{}' at line {}, invalid range", new Object[]{minString, maxString, this.getLineNumber()});
                    }
                }
            } else {
                this.logger.warn("ignoring <xAxis> element for chart " + (this.currentChart == null ? this.currentChart : this.currentChart.getShortName()) + " without an X axis" + " at line {}", (Object)this.getLineNumber());
            }
        } else if ("data".equals(element)) {
            if (this.currentChart == null) {
                this.logger.warn("ignoring <data> element outside of a chart");
                this.inData = false;
                this.skip = true;
            } else {
                this.inData = true;
                this.skip = false;
                Map<String, String> attributes = this.parseAttributes(unparsedAttributes);
                String stat = attributes.get("stat");
                if (stat != null) {
                    try {
                        this.currentStat = Statistic.valueOf(stat);
                    }
                    catch (IllegalArgumentException iae) {
                        this.logger.warn("ignoring invalid 'stat' attribute {} at line {}", (Object)stat, (Object)this.getLineNumber());
                    }
                }
                this.useSecondaryYAxis = Boolean.parseBoolean(attributes.get("useYAxis2"));
            }
        } else if ("host".equals(element)) {
            this.parseHost(this.parseAttributes(unparsedAttributes));
        } else if ("type".equals(element)) {
            this.parseType(this.parseAttributes(unparsedAttributes));
        } else if ("field".equals(element)) {
            this.parseField(this.parseAttributes(unparsedAttributes));
        } else if ("fieldAlias".equals(element)) {
            this.parseFieldAlias(this.parseAttributes(unparsedAttributes));
        } else if ("marker".equals(element)) {
            Map<String, String> attributes = this.parseAttributes(unparsedAttributes);
            String stat = attributes.get("stat");
            if (stat != null) {
                try {
                    this.markers.add(Statistic.valueOf(stat));
                }
                catch (IllegalArgumentException iae) {
                    this.logger.warn("ignoring invalid 'marker' attribute {} at line {}", (Object)stat, (Object)this.getLineNumber());
                }
            }
        } else if (!"charts".equals(element)) {
            this.logger.warn("unknown element {} at line {}", (Object)element, (Object)this.getLineNumber());
        }
    }

    @Override
    protected void endElement(String element) {
        if (this.currentChart == null) {
            if (!"charts".equals(element)) {
                this.logger.warn("ignoring element </{}> at line {}; current chart is not defined", (Object)element, (Object)this.getLineNumber());
            }
            return;
        }
        if ("linechart".equals(element)) {
            this.charts.add(this.currentChart);
            this.currentChart = null;
        } else if ("intervalchart".equals(element)) {
            this.charts.add(this.currentChart);
            this.currentChart = null;
        } else if ("barchart".equals(element)) {
            this.charts.add(this.currentChart);
            this.currentChart = null;
        } else if ("histogram".equals(element)) {
            this.charts.add(this.currentChart);
            this.currentChart = null;
        } else if ("data".equals(element)) {
            if (!this.skip) {
                this.endDataElement();
            }
            this.resetData();
        }
    }

    private void createLineChart(Map<String, String> attributes) {
        NamingMode mode;
        if (this.currentChart != null) {
            this.logger.warn("ignoring <linechart> element inside another chart definition at line {}", (Object)this.getLineNumber());
            this.skip = true;
            return;
        }
        String title = attributes.get("name");
        if (title == null || "".equals(title)) {
            this.logger.warn("ignoring <linechart> element with no name at line {}", (Object)this.getLineNumber());
            this.skip = true;
            return;
        }
        String shortName = attributes.get("shortName");
        boolean stacked = Boolean.valueOf(attributes.get("stacked"));
        this.currentChart = new LineChartDefinition(shortName == null ? title : shortName, title, stacked);
        if (attributes.get("subtitledBy") != null && (mode = NamingMode.valueOf(attributes.get("subtitledBy"))) != null) {
            this.currentChart.setSubtitleNamingMode(mode);
        }
        if (attributes.get("linesNamedBy") != null) {
            mode = NamingMode.valueOf(attributes.get("linesNamedBy"));
            ((LineChartDefinition)this.currentChart).setLineNamingMode(mode);
        }
        this.parseSize("<linechart>", attributes);
        this.logger.debug("parsed line chart {}", (Object)this.currentChart.getShortName());
    }

    private void createIntervalChart(Map<String, String> attributes) {
        NamingMode mode;
        String title;
        if (this.currentChart != null) {
            this.logger.warn("ignoring <intervalchart> element inside another chart definition at line {}", (Object)this.getLineNumber());
            this.skip = true;
        }
        if ((title = attributes.get("name")) == null || "".equals(title)) {
            this.logger.warn("ignoring <intervalchart> element with no name at line {}", (Object)this.getLineNumber());
            this.skip = true;
            return;
        }
        String shortName = attributes.get("shortName");
        this.currentChart = new IntervalChartDefinition(shortName == null ? title : shortName, title);
        if (attributes.get("subtitledBy") != null && (mode = NamingMode.valueOf(attributes.get("subtitledBy"))) != null) {
            this.currentChart.setSubtitleNamingMode(mode);
        }
        if (attributes.get("linesNamedBy") != null) {
            mode = NamingMode.valueOf(attributes.get("linesNamedBy"));
            ((LineChartDefinition)this.currentChart).setLineNamingMode(mode);
        }
        this.parseSize("<intervalchart>", attributes);
        this.logger.debug("parsed interval chart {}", (Object)this.currentChart.getShortName());
    }

    private void createBarChart(Map<String, String> attributes) {
        NamingMode mode;
        if (this.currentChart != null) {
            this.logger.warn("ignoring <barchart> element inside another chart definition at line {}", (Object)this.getLineNumber());
            this.skip = true;
            return;
        }
        String title = attributes.get("name");
        if (title == null || "".equals(title)) {
            this.logger.warn("ignoring <barchart> element with no name at line {}", (Object)this.getLineNumber());
            this.skip = true;
            return;
        }
        String shortName = attributes.get("shortName");
        boolean stacked = Boolean.valueOf(attributes.get("stacked"));
        boolean subtractionNeeded = Boolean.valueOf(attributes.get("subtractionNeeded"));
        this.currentChart = new BarChartDefinition(shortName == null ? title : shortName, title, stacked, subtractionNeeded);
        if (attributes.get("subtitledBy") != null && (mode = NamingMode.valueOf(attributes.get("subtitledBy"))) != null) {
            this.currentChart.setSubtitleNamingMode(mode);
        }
        if (attributes.get("barsNamedBy") != null) {
            mode = NamingMode.valueOf(attributes.get("barsNamedBy"));
            ((BarChartDefinition)this.currentChart).setBarNamingMode(mode);
        }
        if (attributes.get("categoriesNamedBy") != null) {
            mode = NamingMode.valueOf(attributes.get("categoriesNamedBy"));
            ((BarChartDefinition)this.currentChart).setCategoryNamingMode(mode);
        }
        this.parseSize("<barchart>", attributes);
        this.logger.debug("parsed bar chart {}", (Object)this.currentChart.getShortName());
    }

    private void createHistogram(Map<String, String> attributes) {
        String temp;
        NamingMode mode;
        if (this.currentChart != null) {
            this.logger.warn("ignoring <histogram> element inside another chart definition at line {}", (Object)this.getLineNumber());
            this.skip = true;
            return;
        }
        String title = attributes.get("name");
        if (title == null || "".equals(title)) {
            this.logger.warn("ignoring <histogram> element with no name at line {}", (Object)this.getLineNumber());
            this.skip = true;
            return;
        }
        String shortName = attributes.get("shortName");
        this.currentChart = new HistogramChartDefinition(shortName == null ? title : shortName, title);
        if (attributes.get("barsNamedBy") != null) {
            mode = NamingMode.valueOf(attributes.get("barsNamedBy"));
            ((HistogramChartDefinition)this.currentChart).setHistogramNamingMode(mode);
        }
        if (attributes.get("subtitledBy") != null && (mode = NamingMode.valueOf(attributes.get("subtitledBy"))) != null) {
            this.currentChart.setSubtitleNamingMode(mode);
        }
        if ((temp = attributes.get("bins")) != null) {
            try {
                ((HistogramChartDefinition)this.currentChart).setBins(Integer.parseInt(temp));
            }
            catch (NumberFormatException nfe) {
                this.logger.warn("ignoring <histogram> attribute 'bins' with value {} at line {}, it is not a valid number", (Object)temp, (Object)this.getLineNumber());
            }
        }
        if ((temp = attributes.get("showMarkers")) != null && !Boolean.valueOf(attributes.get("showMarkers")).booleanValue()) {
            ((HistogramChartDefinition)this.currentChart).setMarkers(new Statistic[0]);
        }
        this.parseSize("<histogram>", attributes);
        this.logger.debug("parsed histogram chart {}", (Object)this.currentChart.getShortName());
    }

    private void parseHost(Map<String, String> attributes) {
        if (!this.inData) {
            this.logger.warn("ignoring <host> element outside of <data> at line {}; <data> will be skipped", (Object)this.getLineNumber());
            this.skip = true;
            return;
        }
        if (this.hostMatcher == null) {
            String name = attributes.get("name");
            if (name != null) {
                this.hostMatcher = HostMatcher.ALL.toString().equals(name) ? HostMatcher.ALL : new ExactHostMatcher(name);
            } else {
                String regex = attributes.get("regex");
                if (regex != null) {
                    this.hostMatcher = new RegexHostMatcher(regex);
                } else {
                    String os = attributes.get("os");
                    if (os != null) {
                        this.hostMatcher = new OSMatcher(os);
                    } else {
                        this.logger.error("either 'name', 'regex' or 'os' must be defined for  <host> at line {}; <data> will be skipped", (Object)this.getLineNumber());
                        this.skip = true;
                    }
                }
            }
            this.hostTransformer = this.createTransformer(attributes, true, this.hostTransformer);
        } else {
            this.logger.warn("ignoring extra <host> element at line {}", (Object)this.getLineNumber());
        }
    }

    private void parseType(Map<String, String> attributes) {
        if (!this.inData) {
            this.logger.warn("ignoring <type> element outside of <data> at line {}; <data> will be skipped", (Object)this.getLineNumber());
            this.skip = true;
            return;
        }
        if (this.typeMatcher == null) {
            String name = attributes.get("name");
            if (name != null) {
                this.typeMatcher = "$PROCESSES".equals(name) ? ProcessMatcher.INSTANCE : (TypeMatcher.ALL.toString().equals(name) ? TypeMatcher.ALL : new ExactTypeMatcher(name));
            } else {
                String regex = attributes.get("regex");
                if (regex != null) {
                    this.typeMatcher = new RegexTypeMatcher(regex);
                } else {
                    this.logger.error("either 'name' or 'regex' must be defined for  <type> at line {}; <data> will be skipped", (Object)this.getLineNumber());
                    this.skip = true;
                }
            }
            this.typeTransformer = this.createTransformer(attributes, true, this.typeTransformer);
        } else {
            this.logger.warn("ignoring extra <type> element at line {}", (Object)this.getLineNumber());
        }
    }

    private void parseField(Map<String, String> attributes) {
        if (!this.inData) {
            this.logger.warn("ignoring <field> element outside of <data> at line {}; <data> will be skipped", (Object)this.getLineNumber());
            this.skip = true;
            return;
        }
        String name = attributes.get("name");
        if (name != null) {
            if (FieldMatcher.ALL.toString().equals(name)) {
                this.fieldMatchers.add(FieldMatcher.ALL);
            } else {
                this.fieldMatchers.add(new ExactFieldMatcher(name));
            }
            NameTransformer transformer = this.createTransformer(attributes, true, null);
            if (transformer != null) {
                this.fieldTransformers.put(name, (SimpleNameTransformer)transformer);
            }
        } else {
            String regex = attributes.get("regex");
            if (regex != null) {
                this.fieldMatchers.add(new RegexFieldMatcher(regex));
                NameTransformer transformer = this.createTransformer(attributes, false, this.regexFieldRegexTransformer);
                if (transformer != null) {
                    this.regexFieldRegexTransformer = (RegexNameTransformer)transformer;
                }
            } else {
                this.logger.error("either 'name' or 'regex' must be defined for <field> at line {}; <data> will be skipped", (Object)this.getLineNumber());
                this.skip = true;
            }
        }
    }

    private void parseFieldAlias(Map<String, String> attributes) {
        if (!this.inData) {
            this.logger.warn("ignoring <fieldAlias> element outside of <data> at line {}; <data> will be skipped", (Object)this.getLineNumber());
            this.skip = true;
            return;
        }
        String name = attributes.get("name");
        if (name == null) {
            this.logger.warn("'name' must be defined for <fieldAlias> at line {}", (Object)this.getLineNumber());
            return;
        }
        String value = attributes.get("value");
        if (value == null) {
            this.logger.warn("'value' must be defined for <fieldAlias> at line {}", (Object)this.getLineNumber());
        } else {
            this.fieldTransformers.put(name, new SimpleNameTransformer(value));
        }
    }

    private void parseSize(String elementName, Map<String, String> attributes) {
        String temp;
        if (attributes.get("width") != null) {
            temp = attributes.get("width");
            try {
                this.currentChart.setWidth(Integer.parseInt(temp));
            }
            catch (NumberFormatException nfe) {
                this.logger.warn("ignoring " + elementName + " attribute " + "'width'" + " with value '{}'" + " at line {}" + ", is not a valid number", (Object)temp, (Object)this.getLineNumber());
            }
        }
        if (attributes.get("height") != null) {
            temp = attributes.get("height");
            try {
                this.currentChart.setHeight(Integer.parseInt(temp));
            }
            catch (NumberFormatException nfe) {
                this.logger.warn("ignoring " + elementName + " attribute " + "'height'" + " with value '{}'" + " at line {}" + ", is not a valid number", (Object)temp, (Object)this.getLineNumber());
            }
        }
    }

    private void endDataElement() {
        if (this.typeMatcher == null) {
            this.logger.warn("ignoring <data> element without a <type>at line {} <type> is required", (Object)this.getLineNumber());
            return;
        }
        ArrayList<FieldMatcher> consolidatedMatchers = new ArrayList<FieldMatcher>(this.fieldMatchers.size());
        ArrayList<String> names = new ArrayList<String>(this.fieldMatchers.size());
        for (FieldMatcher matcher : this.fieldMatchers) {
            if (matcher.getClass().equals(ExactFieldMatcher.class)) {
                String name = ((ExactFieldMatcher)matcher).getField();
                if ("$DISKS".equals(name)) {
                    consolidatedMatchers.add(DiskMatcher.INSTANCE);
                    continue;
                }
                if ("$PARTITIONS".equals(name)) {
                    consolidatedMatchers.add(PartitionMatcher.INSTANCE);
                    continue;
                }
                names.add(name);
                continue;
            }
            consolidatedMatchers.add(matcher);
        }
        if (names.size() == 0 && consolidatedMatchers.size() == 0) {
            consolidatedMatchers.add(FieldMatcher.ALL);
        } else if (names.size() == 1) {
            consolidatedMatchers.add(new ExactFieldMatcher((String)names.get(0)));
        } else if (names.size() > 1) {
            consolidatedMatchers.add(new SetFieldMatcher(names.toArray(new String[names.size()])));
        }
        for (FieldMatcher fieldMatcher : consolidatedMatchers) {
            HistogramChartDefinition histogramChart;
            DefaultDataDefinition definition = new DefaultDataDefinition(this.hostMatcher, this.typeMatcher, fieldMatcher, this.currentStat, this.useSecondaryYAxis);
            for (String field : this.fieldTransformers.keySet()) {
                definition.addFieldTransformer(field, this.fieldTransformers.get(field));
            }
            if (this.hostTransformer != null) {
                if (this.hostMatcher.getClass().equals(ExactHostMatcher.class)) {
                    definition.addHostnameTransformer(((ExactHostMatcher)this.hostMatcher).getHostname(), this.hostTransformer);
                } else {
                    definition.addHostnameTransformer("$ALL", this.hostTransformer);
                }
            }
            if (this.typeTransformer != null) {
                if (this.typeMatcher.getClass().equals(ExactTypeMatcher.class)) {
                    definition.addTypeTransformer(((ExactTypeMatcher)this.typeMatcher).getType(), this.typeTransformer);
                } else {
                    definition.addTypeTransformer("$ALL", this.typeTransformer);
                }
            }
            if (this.regexFieldRegexTransformer != null) {
                definition.addFieldTransformer("$ALL", this.regexFieldRegexTransformer);
            }
            this.currentChart.addData(definition);
            if (this.currentChart instanceof HistogramChartDefinition && (histogramChart = (HistogramChartDefinition)this.currentChart).getMarkerCount() != 0 && this.markers.size() > 0) {
                histogramChart.setMarkers(this.markers.toArray(new Statistic[this.markers.size()]));
            }
            this.logger.debug("added {} to chart {}", (Object)definition, (Object)this.currentChart.getShortName());
        }
    }

    private NameTransformer createTransformer(Map<String, String> attributes, boolean aliasAllowed, NameTransformer existing) {
        String alias = attributes.get("alias");
        if (alias != null) {
            if (aliasAllowed) {
                return new SimpleNameTransformer(alias);
            }
            this.logger.warn("ignoring invalid 'alias' attribute at line {}", (Object)this.getLineNumber());
            return existing;
        }
        String regex = attributes.get("aliasRegex");
        if (regex == null) {
            regex = attributes.get("regex");
        }
        if (regex != null) {
            if (existing != null) {
                this.logger.warn("an existing regex substitution has already been defined, ignoring additional substitutions at line {}", (Object)this.getLineNumber());
                return existing;
            }
            String group = attributes.get("aliasByGroup");
            if (group == null) {
                String replacement = attributes.get("aliasByReplacement");
                if (replacement != null && !"".equals(replacement)) {
                    return new RegexNameTransformer(regex, replacement);
                }
                return new RegexNameTransformer(regex);
            }
            try {
                return new RegexNameTransformer(regex, Integer.parseInt(group));
            }
            catch (NumberFormatException nfe) {
                this.logger.warn("'aliasByGroup' must be a number at line {}", (Object)this.getLineNumber());
                return existing;
            }
        }
        return existing;
    }

    @Override
    protected void reset() {
        super.reset();
        this.charts.clear();
        this.currentChart = null;
        this.resetData();
    }

    private void resetData() {
        this.hostMatcher = null;
        this.hostTransformer = null;
        this.typeMatcher = null;
        this.typeTransformer = null;
        this.fieldMatchers.clear();
        this.fieldTransformers.clear();
        this.regexFieldRegexTransformer = null;
        this.inData = false;
        this.skip = false;
        this.currentStat = Statistic.AVERAGE;
        this.useSecondaryYAxis = false;
    }
}

