/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.chart.definition;

import com.ibm.nmon.analysis.Statistic;
import com.ibm.nmon.chart.definition.YAxisChartDefinition;
import com.ibm.nmon.data.definition.NamingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.data.Range;

public final class HistogramChartDefinition
extends YAxisChartDefinition {
    private int bins = 10;
    private String xAxisLabel = "";
    private Range xAxisRange;
    private NamingMode histogramNamingMode;
    private final List<Statistic> markers;

    public HistogramChartDefinition(String shortName, String title) {
        super(shortName, title, false);
        this.xAxisRange = null;
        this.histogramNamingMode = NamingMode.FIELD;
        this.markers = new ArrayList<Statistic>(3);
        this.markers.add(Statistic.AVERAGE);
        this.markers.add(Statistic.MEDIAN);
        this.markers.add(Statistic.PERCENTILE_95);
    }

    public HistogramChartDefinition(HistogramChartDefinition copy, boolean copyData) {
        super(copy, copyData);
        this.bins = copy.bins;
        this.xAxisLabel = copy.xAxisLabel;
        this.xAxisRange = copy.xAxisRange;
        this.histogramNamingMode = copy.histogramNamingMode;
        this.markers = new ArrayList<Statistic>(copy.markers);
    }

    public int getBins() {
        return this.bins;
    }

    public void setBins(int bins) {
        this.bins = bins;
    }

    public String getXAxisLabel() {
        return this.xAxisLabel;
    }

    public void setXAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel == null ? "" : xAxisLabel;
    }

    public Range getXAxisRange() {
        return this.xAxisRange;
    }

    public void setXAxisRange(Range range) {
        this.xAxisRange = range;
    }

    public NamingMode getHistogramNamingMode() {
        return this.histogramNamingMode;
    }

    public void setHistogramNamingMode(NamingMode histogramNamingMode) {
        this.histogramNamingMode = histogramNamingMode == null ? NamingMode.FIELD : histogramNamingMode;
    }

    public int getMarkerCount() {
        return this.markers.size();
    }

    public Iterable<Statistic> getMarkers() {
        return Collections.unmodifiableList(this.markers);
    }

    public void setMarkers(Statistic ... stats) {
        this.markers.clear();
        for (Statistic stat : stats) {
            this.markers.add(stat);
        }
    }
}

