/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data;

import com.ibm.nmon.data.DataSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BasicDataSet
extends DataSet {
    private final Map<String, String> metadata = new HashMap<String, String>();

    public BasicDataSet(String sourceFile) {
        if (sourceFile == null || "".equals(sourceFile)) {
            throw new IllegalArgumentException("sourceFile cannot be null");
        }
        this.metadata.put("source_file", sourceFile);
    }

    @Override
    public final String getHostname() {
        return this.metadata.get("hostname");
    }

    @Override
    public void setHostname(String hostname) {
        if (hostname == null || "".equals(hostname)) {
            throw new IllegalArgumentException("hostname cannot be null");
        }
        this.metadata.put("hostname", hostname);
    }

    @Override
    public String getSourceFile() {
        return this.metadata.get("source_file");
    }

    Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public final String getMetadata(String name) {
        return this.metadata.get(name);
    }

    public final int getMetadataCount() {
        return this.metadata.size();
    }

    public final Iterable<String> getMetadataNames() {
        return Collections.unmodifiableSet(this.metadata.keySet());
    }

    public final void setMetadata(String name, String value) {
        if (name != null && !"".equals(name) && value != null && !"".equals(value)) {
            this.metadata.put(name, value);
        }
    }
}

