/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data;

import com.ibm.nmon.data.ArrayPool;
import com.ibm.nmon.data.DataType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class DataRecord
implements Comparable<DataRecord> {
    private long time;
    private final String timestamp;
    private final Map<DataType, double[]> values = new HashMap<DataType, double[]>();

    public DataRecord(long time, String timestamp) {
        this.time = time;
        if (timestamp == null || timestamp.equals("")) {
            throw new IllegalArgumentException("timstamp cannot be empty");
        }
        this.timestamp = timestamp;
    }

    public long getTime() {
        return this.time;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    final void adjustTime(long adjustmentMillis) {
        if (adjustmentMillis == 0L) {
            return;
        }
        this.time += adjustmentMillis;
    }

    public void setValue(DataType type, String field, double value) {
        int idx = type.getFieldIndex(field);
        double[] data = this.values.get(type);
        if (data == null) {
            data = new double[type.getFieldCount()];
            Arrays.fill(data, Double.NaN);
            this.values.put(type, data);
        }
        data[idx] = value;
    }

    public void addData(DataType type, double[] data) {
        if (this.values.containsKey(type.getId())) {
            throw new IllegalArgumentException("DataType " + type.getId() + " already defined for timestamp " + this.timestamp);
        }
        if (data.length < type.getFieldCount()) {
            throw new IllegalArgumentException("DataType " + type.getId() + " defines " + type.getFieldCount() + " fields but there are only " + data.length + " values recorded for timestamp " + this.timestamp);
        }
        this.values.put(type, ArrayPool.getArray(data));
    }

    public boolean removeData(DataType type) {
        return this.values.remove(type) != null;
    }

    public double getData(DataType type, String fieldName) {
        double[] data = this.values.get(type);
        if (data == null) {
            throw new IllegalArgumentException("record does not contain any data for DataType " + type.getId());
        }
        int fieldIndex = type.getFieldIndex(fieldName);
        return data[fieldIndex];
    }

    public double[] getData(DataType type) {
        double[] data = this.values.get(type);
        if (data == null) {
            throw new IllegalArgumentException("record does not contain any data for DataType " + type.getId());
        }
        return data;
    }

    public boolean hasData(DataType type) {
        return this.values.containsKey(type);
    }

    public String toString() {
        return "{timestamp=" + this.getTimestamp() + ", dataTypes=" + this.values.keySet() + '}';
    }

    @Override
    public final int compareTo(DataRecord r) {
        return (int)(this.time - r.time);
    }
}

