/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data;

import com.ibm.nmon.data.DataRecord;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.interval.Interval;
import java.util.Collections;
import java.util.Set;
import java.util.TreeMap;

public abstract class DataSet
implements Comparable<DataSet> {
    private final TreeMap<String, DataType> dataTypes = new TreeMap();
    private final TreeMap<Long, DataRecord> data = new TreeMap();

    public abstract String getHostname();

    public abstract void setHostname(String var1);

    public abstract String getSourceFile();

    public final void addType(DataType type) {
        if (type != null) {
            if (this.dataTypes.containsKey(type.getId())) {
                throw new IllegalArgumentException("cannot redefine DataType " + type.getId() + " within the same data set");
            }
            this.dataTypes.put(type.getId(), type);
        }
    }

    final void removeType(DataType type) {
        if (type != null) {
            this.dataTypes.remove(type.getId());
        }
    }

    public final boolean containsType(String typeId) {
        return this.dataTypes.containsKey(typeId);
    }

    public final DataType getType(String typeId) {
        return this.dataTypes.get(typeId);
    }

    public final Iterable<DataType> getTypes() {
        return Collections.unmodifiableCollection(this.dataTypes.values());
    }

    public final int getTypeCount() {
        return this.dataTypes.size();
    }

    public final void addRecord(DataRecord record) {
        if (record != null) {
            this.data.put(record.getTime(), record);
        }
    }

    public final int getRecordCount() {
        return this.data.size();
    }

    public final int getRecordCount(Interval interval) {
        if (Interval.DEFAULT.equals(interval)) {
            return this.data.size();
        }
        return this.data.subMap(interval.getStart(), true, interval.getEnd(), true).size();
    }

    public final DataRecord getRecord(long time) {
        return this.data.get(time);
    }

    public final Iterable<DataRecord> getRecords() {
        return Collections.unmodifiableCollection(this.data.values());
    }

    public final Iterable<DataRecord> getRecords(Interval interval) {
        if (Interval.DEFAULT.equals(interval)) {
            return Collections.unmodifiableCollection(this.data.values());
        }
        return Collections.unmodifiableCollection(this.data.subMap(interval.getStart(), true, interval.getEnd(), true).values());
    }

    public final Set<Long> getTimes() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    public final long getStartTime() {
        return this.data.firstKey();
    }

    public final long getEndTime() {
        return this.data.size() == 0 ? Long.MIN_VALUE : this.data.lastKey();
    }

    public final void adjustTimes(long adjustmentMillis) {
        if (adjustmentMillis == 0L) {
            return;
        }
        TreeMap<Long, DataRecord> newData = new TreeMap<Long, DataRecord>();
        for (long time : this.data.keySet()) {
            DataRecord record = this.data.get(time);
            record.adjustTime(adjustmentMillis);
            newData.put(time + adjustmentMillis, record);
        }
        this.data.clear();
        this.data.putAll(newData);
    }

    public final String toString() {
        return this.getHostname();
    }

    public final int hashCode() {
        return (this.getHostname() + '|' + this.getStartTime() + '|' + this.getEndTime()).hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DataSet) {
            DataSet data = (DataSet)obj;
            return this.getHostname().equals(data.getHostname()) && this.getStartTime() == data.getStartTime() && this.getEndTime() == data.getEndTime();
        }
        return false;
    }

    @Override
    public final int compareTo(DataSet f) {
        int compare = this.getHostname().compareTo(f.getHostname());
        if (compare == 0) {
            if (this.data.isEmpty() && this.data.isEmpty()) {
                return 0;
            }
            if (this.getStartTime() == f.getStartTime()) {
                if (this.getEndTime() == f.getEndTime()) {
                    return 0;
                }
                return this.getEndTime() > f.getEndTime() ? 1 : -1;
            }
            return this.getStartTime() > f.getStartTime() ? 1 : -1;
        }
        return compare;
    }
}

