/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataType;

public final class DataTuple {
    private final DataSet dataSet;
    private final DataType type;
    private final String field;

    public DataTuple(DataSet dataSet, DataType type, String field) {
        if (dataSet == null) {
            throw new IllegalArgumentException("data set cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("data type cannot be null");
        }
        this.dataSet = dataSet;
        this.type = type;
        this.field = field;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public DataType getDataType() {
        return this.type;
    }

    public String getField() {
        return this.field;
    }

    public boolean equals(Object obj) {
        DataTuple t;
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass() && this.dataSet.equals((t = (DataTuple)obj).getDataSet()) && this.getDataType().equals(t.getDataType())) {
            if (this.getField() == null) {
                return null == t.getField();
            }
            return this.getField().equals(t.getField());
        }
        return false;
    }

    public String toString() {
        return this.dataSet + ": " + this.type + (this.field == null ? "-" + this.field : "");
    }

    public int hashCode() {
        int code = this.getDataSet().hashCode();
        code = code * 59 + this.getDataType().hashCode();
        if (this.getField() != null) {
            code = code * 73 + this.getField().hashCode();
        }
        return code;
    }
}

