/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataType {
    protected final String id;
    private final String name;
    private final List<String> orderedFields;
    private final Map<String, Integer> fields;
    private final Map<String, String> fieldKeys;

    public DataType(String id, String name, String ... fields) {
        if (id == null || id.equals("")) {
            throw new IllegalArgumentException("id cannot be empty");
        }
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        if (fields == null) {
            throw new IllegalArgumentException("fields cannot be null");
        }
        if (fields.length == 0) {
            throw new IllegalArgumentException("fields cannot be empty");
        }
        this.id = id;
        this.name = name;
        this.orderedFields = Collections.unmodifiableList(Arrays.asList(fields));
        this.fields = new HashMap<String, Integer>(fields.length);
        for (int i = 0; i < this.orderedFields.size(); ++i) {
            this.fields.put(this.orderedFields.get(i), i);
        }
        this.fieldKeys = new HashMap<String, String>(fields.length);
    }

    public final String getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public final int getFieldCount() {
        return this.orderedFields.size();
    }

    public final String getField(int index) {
        return this.orderedFields.get(index);
    }

    public final int getFieldIndex(String name) {
        Integer i = this.fields.get(name);
        if (i == null) {
            throw new IllegalArgumentException("DataType " + this.id + " does not have a field named " + name);
        }
        return i;
    }

    public final boolean hasField(String name) {
        return this.fields.containsKey(name);
    }

    public final List<String> getFields() {
        return this.orderedFields;
    }

    public final String getKey(String field) {
        String key = this.fieldKeys.get(field);
        if (key == null) {
            this.getFieldIndex(field);
            key = this.getId() + ':' + field;
            this.fieldKeys.put(field, key);
        }
        return key;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DataType) {
            DataType type = (DataType)o;
            return type.id.equals(this.id);
        }
        return false;
    }

    public String toString() {
        return this.id;
    }
}

