/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data;

import com.ibm.nmon.data.ProcessDataSet;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public final class NMONDataSet
extends ProcessDataSet {
    private final Map<String, String> metadata = new TreeMap<String, String>();
    private final Map<String, String> systemInfo = new TreeMap<String, String>();

    public NMONDataSet(String sourceFile) {
        if (sourceFile == null || "".equals(sourceFile)) {
            throw new IllegalArgumentException("sourceFile cannot be null");
        }
        this.metadata.put("source_file", sourceFile);
    }

    @Override
    public String getHostname() {
        return this.metadata.get("host");
    }

    @Override
    public void setHostname(String hostname) {
        if (hostname == null || "".equals(hostname)) {
            throw new IllegalArgumentException("hostname cannot be null");
        }
        this.metadata.put("host", hostname);
    }

    @Override
    public String getSourceFile() {
        return this.metadata.get("source_file");
    }

    Map<String, String> getSystemInfo() {
        return Collections.unmodifiableMap(this.systemInfo);
    }

    public String getSystemInfo(String name) {
        return this.systemInfo.get(name);
    }

    public int getSystemInfoCount() {
        return this.systemInfo.size();
    }

    public Iterable<String> getSystemInfoNames() {
        return Collections.unmodifiableSet(this.systemInfo.keySet());
    }

    public void setSystemInfo(String name, String value) {
        if (name != null && !"".equals(name) && value != null && !"".equals(value)) {
            this.systemInfo.put(name, value);
        }
    }

    Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public String getMetadata(String name) {
        return this.metadata.get(name);
    }

    public int getMetadataCount() {
        return this.metadata.size();
    }

    public Iterable<String> getMetadataNames() {
        return Collections.unmodifiableSet(this.metadata.keySet());
    }

    public void setMetadata(String name, String value) {
        if (name != null && !"".equals(name) && value != null && !"".equals(value)) {
            this.metadata.put(name, value);
        }
    }
}

