/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data;

import com.ibm.nmon.data.ProcessDataSet;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public final class PerfmonDataSet
extends ProcessDataSet {
    private final Map<String, String> metadata = new TreeMap<String, String>();

    public PerfmonDataSet(String sourceFile) {
        if (sourceFile == null || "".equals(sourceFile)) {
            throw new IllegalArgumentException("sourceFile cannot be null");
        }
        this.metadata.put("source_file", sourceFile);
    }

    @Override
    public String getHostname() {
        return this.metadata.get("host");
    }

    @Override
    public void setHostname(String hostname) {
        if (hostname == null || "".equals(hostname)) {
            throw new IllegalArgumentException("hostname cannot be null");
        }
        this.metadata.put("host", hostname);
    }

    @Override
    public String getSourceFile() {
        return this.metadata.get("source_file");
    }

    @Override
    public String getTypeIdPrefix() {
        return "Process";
    }

    Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public String getMetadata(String name) {
        return this.metadata.get(name);
    }

    public int getMetadataCount() {
        return this.metadata.size();
    }

    public Iterable<String> getMetadataNames() {
        return Collections.unmodifiableSet(this.metadata.keySet());
    }

    public void setMetadata(String name, String value) {
        if (name != null && !"".equals(name) && value != null && !"".equals(value)) {
            this.metadata.put(name, value);
        }
    }
}

