/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data;

public final class Process
implements Comparable<Process> {
    private final int id;
    private final String name;
    private String commandLine;
    private final long startTime;
    private long endTime = Long.MAX_VALUE;
    private final String typeId;

    public Process(int id, long startTime, String name) {
        this(id, startTime, name, "TOP");
    }

    public Process(int id, long startTime, String name, String typeName) {
        this.id = id;
        this.startTime = startTime;
        this.name = name;
        this.commandLine = "";
        this.typeId = id == -1 ? typeName + "-ALL-" + name : typeName + "-" + id + '@' + startTime;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setCommandLine(String commandLine) {
        this.commandLine = commandLine == null ? "" : commandLine;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        if (this.startTime > endTime) {
            throw new IllegalArgumentException("end time must be greater than start time");
        }
        this.endTime = endTime;
    }

    public String toString() {
        if (this.id == -1) {
            return this.name;
        }
        return this.name + " (" + this.id + ')';
    }

    String getTypeId() {
        return this.typeId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Process) {
            Process p = (Process)obj;
            if (this.id == -1) {
                return this.name.equals(p.name);
            }
            return this.id == p.id && this.startTime == p.startTime;
        }
        return false;
    }

    public int hashCode() {
        if (this.id == -1) {
            return this.name.hashCode();
        }
        return this.id * 17 << 16 & (int)(this.startTime ^ this.startTime >>> 32);
    }

    @Override
    public int compareTo(Process p) {
        int compare = this.name.compareTo(p.name);
        if (compare == 0) {
            return this.id - p.id;
        }
        return compare;
    }
}

