/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data;

import com.ibm.nmon.data.DataRecord;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.Process;
import com.ibm.nmon.data.ProcessDataType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class ProcessDataSet
extends DataSet {
    private final Set<Process> processes = new HashSet<Process>();

    public final void addProcess(Process process) {
        this.processes.add(process);
    }

    public final Iterable<Process> getProcesses() {
        return Collections.unmodifiableSet(this.processes);
    }

    public final int getProcessCount() {
        return this.processes.size();
    }

    public final ProcessDataType getType(Process process) {
        return (ProcessDataType)this.getType(process.getTypeId());
    }

    public String getTypeIdPrefix() {
        return "TOP";
    }

    public final Process changeStartTime(Process process, long newStartTime) {
        if (this.processes.contains(process)) {
            return process;
        }
        ProcessDataType type = this.getType(process);
        Process newProcess = new Process(process.getId(), newStartTime, process.getName());
        ProcessDataType newType = new ProcessDataType(newProcess, type.getFields().toArray(new String[type.getFieldCount()]));
        for (DataRecord record : this.getRecords()) {
            if (!record.hasData(type)) continue;
            record.addData(newType, record.getData(type));
            record.removeData(type);
        }
        this.removeType(type);
        this.addType(newType);
        this.processes.remove(process);
        this.processes.add(newProcess);
        return newProcess;
    }
}

