/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data;

import com.ibm.nmon.data.DataType;

public final class SubDataType
extends DataType {
    private final String subId;
    private final String asString;

    public SubDataType(String id, String subId, String name, String ... fields) {
        this(id, subId, name, true, fields);
    }

    public SubDataType(String id, String subId, String name, boolean displayPrimaryId, String ... fields) {
        super(SubDataType.buildId(id, subId), name, fields);
        if (subId == null || subId.equals("")) {
            throw new IllegalArgumentException("subId cannot be empty");
        }
        this.subId = subId;
        this.asString = displayPrimaryId ? this.id : this.subId;
    }

    public String getPrimaryId() {
        int idx = this.getId().indexOf(" (");
        return this.getId().substring(0, idx);
    }

    public String getSubId() {
        return this.subId;
    }

    public static String buildId(String id, String subId) {
        if (subId == null) {
            return id;
        }
        return id + " (" + subId + ')';
    }

    @Override
    public String toString() {
        return this.asString;
    }
}

