/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data;

import com.ibm.nmon.data.BasicDataSet;
import com.ibm.nmon.data.DataRecord;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.NMONDataSet;
import com.ibm.nmon.data.PerfmonDataSet;
import com.ibm.nmon.data.Process;
import com.ibm.nmon.data.ProcessDataSet;
import com.ibm.nmon.data.ProcessDataType;
import com.ibm.nmon.data.SubDataType;
import com.ibm.nmon.interval.Interval;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemDataSet
extends ProcessDataSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemDataSet.class);
    private final TreeMap<Long, Map<String, String>> systemInfo = new TreeMap();
    private final TreeMap<Long, Map<String, String>> metadata = new TreeMap();
    private final TreeMap<Interval, String> sourceFiles = new TreeMap();
    private final String hostname;
    private String typeIdPrefix = "TOP";

    public SystemDataSet(String hostname) {
        if (hostname == null || "".equals(hostname)) {
            throw new IllegalArgumentException("hostname cannot be null");
        }
        this.hostname = hostname;
    }

    @Override
    public final String getHostname() {
        return this.hostname;
    }

    @Override
    public void setHostname(String hostname) {
        throw new UnsupportedOperationException("hostname cannot be changed");
    }

    @Override
    public String getSourceFile() {
        int size = this.sourceFiles.size();
        if (size == 0) {
            return "no data";
        }
        if (size == 1) {
            return this.sourceFiles.values().iterator().next();
        }
        return size + " files";
    }

    public Iterable<String> getSourceFiles() {
        return Collections.unmodifiableCollection(this.sourceFiles.values());
    }

    public String getSourceFile(Interval interval) {
        return this.sourceFiles.get(interval);
    }

    public int getSourceFileCount() {
        return this.sourceFiles.size();
    }

    public Iterable<Interval> getSourceFileIntervals() {
        return Collections.unmodifiableSet(this.sourceFiles.keySet());
    }

    public boolean containsSourceFile(String sourceFile) {
        return this.sourceFiles.values().contains(sourceFile);
    }

    public void addData(SystemDataSet newData) {
        long startT = System.nanoTime();
        this.merge(newData);
        this.sourceFiles.putAll(newData.sourceFiles);
        this.metadata.putAll(newData.metadata);
        this.systemInfo.putAll(newData.systemInfo);
        if (!this.typeIdPrefix.equals(newData.typeIdPrefix)) {
            this.typeIdPrefix = this.typeIdPrefix + " + " + newData.typeIdPrefix;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("data for {} consolidated into data for {} in {}ms ", new Object[]{newData, this.getHostname(), (double)(System.nanoTime() - startT) / 1000000.0});
        }
    }

    public void addData(String sourceFile, DataSet newData) {
        ProcessDataSet nmonData;
        long startT = System.nanoTime();
        if (sourceFile == null || "".equals(sourceFile)) {
            throw new IllegalArgumentException("source file cannot be null");
        }
        this.merge(newData);
        long start = newData.getStartTime();
        long end = newData.getEndTime();
        this.sourceFiles.put(new Interval(start, end), sourceFile);
        if (newData.getClass().equals(BasicDataSet.class)) {
            this.metadata.put(start, ((BasicDataSet)newData).getMetadata());
        } else if (newData.getClass().equals(NMONDataSet.class)) {
            nmonData = (NMONDataSet)newData;
            this.systemInfo.put(start, ((NMONDataSet)nmonData).getSystemInfo());
            this.metadata.put(start, ((NMONDataSet)nmonData).getMetadata());
        } else if (newData.getClass().equals(PerfmonDataSet.class)) {
            nmonData = (PerfmonDataSet)newData;
            this.metadata.put(start, ((PerfmonDataSet)nmonData).getMetadata());
        }
        if (newData instanceof ProcessDataSet) {
            String newPrefix = ((ProcessDataSet)newData).getTypeIdPrefix();
            if (this.getRecordCount() == newData.getRecordCount()) {
                this.typeIdPrefix = newPrefix;
            } else if (!this.typeIdPrefix.contains(newPrefix)) {
                this.typeIdPrefix = this.typeIdPrefix + " + " + newPrefix;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("data for {} consolidated into data for {} in {}ms ", new Object[]{sourceFile, this.getHostname(), (double)(System.nanoTime() - startT) / 1000000.0});
        }
    }

    private void merge(DataSet newData) {
        if (newData == null) {
            throw new IllegalArgumentException("DataSet cannot be null");
        }
        if (newData.getRecordCount() == 0) {
            return;
        }
        HashSet<Long> combinedTimes = null;
        if (this.getRecordCount() != 0) {
            combinedTimes = new HashSet<Long>(this.getTimes());
            combinedTimes.addAll(newData.getTimes());
        }
        for (DataType newType : newData.getTypes()) {
            if (newType instanceof ProcessDataType) {
                ProcessDataType newProcessType = (ProcessDataType)newType;
                Process newProcess = newProcessType.getProcess();
                Process existingProcess = null;
                for (Process toSearch : this.getProcesses()) {
                    if (!newProcess.getName().equals(toSearch.getName()) || newProcess.getId() != toSearch.getId()) continue;
                    existingProcess = toSearch;
                    break;
                }
                if (existingProcess != null) {
                    this.addProcessData(newData, newProcessType, existingProcess);
                    continue;
                }
                this.addProcess(newProcess);
                this.addType(newProcessType);
                this.addDataForType(newData, newProcessType);
                continue;
            }
            if (!this.containsType(newType.getId())) {
                this.addType(newType);
                this.addDataForType(newData, newType);
                continue;
            }
            this.mergeDataForType(newData, newType, combinedTimes);
        }
    }

    private void addDataForType(DataSet data, DataType type) {
        long start = System.nanoTime();
        int n = 0;
        for (DataRecord newRecord : data.getRecords()) {
            long time = newRecord.getTime();
            DataRecord recordToUpdate = this.getRecord(time);
            if (recordToUpdate == null) {
                recordToUpdate = new DataRecord(time, newRecord.getTimestamp());
                this.addRecord(recordToUpdate);
            }
            if (recordToUpdate.hasData(type)) {
                LOGGER.warn("not overwriting existing {} data at time {}", (Object)type, (Object)newRecord.getTimestamp());
                continue;
            }
            if (!newRecord.hasData(type)) continue;
            recordToUpdate.addData(type, newRecord.getData(type));
            ++n;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{} of {} data records for {} {} added in {}ms ", new Object[]{n, data.getRecordCount(), data, type, (double)(System.nanoTime() - start) / 1000000.0});
        }
    }

    private void addProcessData(DataSet data, ProcessDataType processType, Process existingProcess) {
        long start = System.nanoTime();
        int n = 0;
        Process newProcess = processType.getProcess();
        long newStartTime = Math.min(newProcess.getStartTime(), existingProcess.getStartTime());
        Process updatedProcess = this.changeStartTime(existingProcess, newStartTime);
        ProcessDataType updatedProcessType = this.getType(updatedProcess);
        for (DataRecord newRecord : data.getRecords()) {
            long time = newRecord.getTime();
            DataRecord recordToUpdate = this.getRecord(time);
            if (recordToUpdate == null) {
                recordToUpdate = new DataRecord(time, newRecord.getTimestamp());
                this.addRecord(recordToUpdate);
            }
            if (recordToUpdate.hasData(updatedProcessType)) {
                LOGGER.warn("not overwriting existing {} data at time {}", (Object)updatedProcessType, (Object)newRecord.getTimestamp());
                continue;
            }
            if (!newRecord.hasData(processType)) continue;
            recordToUpdate.addData(updatedProcessType, newRecord.getData(processType));
            ++n;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{} of {} process data records for {} {} added in {}ms ", new Object[]{n, data.getRecordCount(), data, updatedProcessType, (double)(System.nanoTime() - start) / 1000000.0});
        }
    }

    private void mergeDataForType(DataSet newData, DataType newType, Set<Long> combinedTimes) {
        DataType existingType = this.getType(newType.getId());
        TreeSet<String> combinedFields = new TreeSet<String>(existingType.getFields());
        combinedFields.addAll(newType.getFields());
        if (combinedFields.size() == existingType.getFieldCount() && combinedFields.size() == newType.getFieldCount()) {
            this.addDataForType(newData, newType);
            return;
        }
        long start = System.nanoTime();
        DataType combinedType = null;
        if (existingType instanceof SubDataType) {
            SubDataType subType = (SubDataType)existingType;
            combinedType = new SubDataType(subType.getPrimaryId(), subType.getSubId(), existingType.getName(), combinedFields.toArray(new String[0]));
        } else {
            combinedType = new DataType(existingType.getId(), existingType.getName(), combinedFields.toArray(new String[0]));
        }
        this.removeType(existingType);
        this.addType(combinedType);
        int fieldCount = combinedFields.size();
        for (long time : combinedTimes) {
            boolean hasNewData;
            DataRecord existingRecord = this.getRecord(time);
            DataRecord newRecord = newData.getRecord(time);
            boolean hasExistingData = existingRecord != null && existingRecord.hasData(existingType);
            boolean bl = hasNewData = newRecord != null && newRecord.hasData(newType);
            if (!hasExistingData && !hasNewData) continue;
            double[] combinedData = new double[fieldCount];
            int n = 0;
            for (String field : combinedFields) {
                if (newType.hasField(field)) {
                    if (hasExistingData && existingType.hasField(field)) {
                        combinedData[n] = existingRecord.getData(existingType, field);
                        LOGGER.warn("not overwriting existing {} data at time {}", (Object)newType, (Object)existingRecord.getTimestamp());
                    } else {
                        combinedData[n] = hasNewData ? newRecord.getData(newType, field) : Double.NaN;
                    }
                } else {
                    combinedData[n] = hasExistingData ? existingRecord.getData(existingType, field) : Double.NaN;
                }
                ++n;
            }
            if (existingRecord == null) {
                DataRecord combinedRecord = new DataRecord(newRecord.getTime(), newRecord.getTimestamp());
                combinedRecord.addData(combinedType, combinedData);
                this.addRecord(combinedRecord);
                continue;
            }
            existingRecord.removeData(existingType);
            existingRecord.addData(combinedType, combinedData);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("data records for {} {} merged in {}ms ", new Object[]{newData, combinedType, (double)(System.nanoTime() - start) / 1000000.0});
        }
    }

    public Iterable<Long> getSystemInfoTimes() {
        return Collections.unmodifiableSet(this.systemInfo.keySet());
    }

    public Map<String, String> getSystemInfo(long time) {
        Map<String, String> toReturn = this.systemInfo.get(time);
        if (toReturn == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(toReturn);
    }

    public int getSystemInfoCount() {
        return this.systemInfo.size();
    }

    public Iterable<Long> getMetadataTimes() {
        return Collections.unmodifiableSet(this.metadata.keySet());
    }

    public Map<String, String> getMetadata(long time) {
        Map<String, String> toReturn = this.metadata.get(time);
        if (toReturn == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(toReturn);
    }

    public int getMetadataCount() {
        return this.metadata.size();
    }

    @Override
    public String getTypeIdPrefix() {
        return this.typeIdPrefix;
    }
}

