/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.definition;

import com.ibm.nmon.analysis.Statistic;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.matcher.FieldMatcher;
import com.ibm.nmon.data.matcher.HostMatcher;
import com.ibm.nmon.data.matcher.TypeMatcher;
import java.util.Collection;
import java.util.List;

public abstract class DataDefinition {
    private final Statistic stat;
    private final boolean useSecondaryYAxis;
    public static DataDefinition ALL_DATA = new DataDefinition(){

        @Override
        public List<DataSet> getMatchingHosts(Collection<DataSet> toMatch) {
            return HostMatcher.ALL.getMatchingHosts(toMatch);
        }

        @Override
        public List<DataType> getMatchingTypes(DataSet data) {
            return TypeMatcher.ALL.getMatchingTypes(data);
        }

        @Override
        public List<String> getMatchingFields(DataType type) {
            return FieldMatcher.ALL.getMatchingFields(type);
        }
    };

    protected DataDefinition() {
        this(null, false);
    }

    protected DataDefinition(Statistic stat, boolean useSecondaryYAxis) {
        if (stat == null) {
            stat = Statistic.AVERAGE;
        }
        this.stat = stat;
        this.useSecondaryYAxis = useSecondaryYAxis;
    }

    public Statistic getStatistic() {
        return this.stat;
    }

    public boolean usesSecondaryYAxis() {
        return this.useSecondaryYAxis;
    }

    public boolean matchesHost(DataSet data) {
        return HostMatcher.ALL.matchesHost(data);
    }

    public abstract List<DataSet> getMatchingHosts(Collection<DataSet> var1);

    public abstract List<DataType> getMatchingTypes(DataSet var1);

    public abstract List<String> getMatchingFields(DataType var1);

    public String renameHost(DataSet data) {
        return data.getHostname();
    }

    public String renameType(DataType type) {
        return type.toString();
    }

    public String renameField(String field) {
        return field;
    }
}

