/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.definition;

import com.ibm.nmon.analysis.Statistic;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.definition.DataDefinition;
import com.ibm.nmon.data.matcher.FieldMatcher;
import com.ibm.nmon.data.matcher.HostMatcher;
import com.ibm.nmon.data.matcher.TypeMatcher;
import com.ibm.nmon.data.transform.name.NameTransformer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DefaultDataDefinition
extends DataDefinition {
    public static final String DEFAULT_NAME_TRANSFORMER_KEY = "$ALL";
    private Map<String, NameTransformer> hostTransformers;
    private Map<String, NameTransformer> typeTransformers;
    private Map<String, NameTransformer> fieldTransformers;
    private final HostMatcher hostMatcher;
    private final TypeMatcher typeMatcher;
    private final FieldMatcher fieldMatcher;

    public DefaultDataDefinition(HostMatcher hostMatcher, TypeMatcher typeMatcher, FieldMatcher fieldMatcher, Statistic stat, boolean useSecondaryYAxis) {
        super(stat, useSecondaryYAxis);
        this.hostMatcher = hostMatcher == null ? HostMatcher.ALL : hostMatcher;
        this.typeMatcher = typeMatcher == null ? TypeMatcher.ALL : typeMatcher;
        this.fieldMatcher = fieldMatcher == null ? FieldMatcher.ALL : fieldMatcher;
    }

    public void addHostnameTransformer(String hostname, NameTransformer transformer) {
        if (transformer != null) {
            if (this.hostTransformers == null) {
                this.hostTransformers = new HashMap<String, NameTransformer>(2);
            }
            this.hostTransformers.put(hostname, transformer);
        }
    }

    public void addTypeTransformer(String typeId, NameTransformer transformer) {
        if (transformer != null) {
            if (this.typeTransformers == null) {
                this.typeTransformers = new HashMap<String, NameTransformer>(2);
            }
            this.typeTransformers.put(typeId, transformer);
        }
    }

    public void addFieldTransformer(String field, NameTransformer transformer) {
        if (transformer != null) {
            if (this.fieldTransformers == null) {
                this.fieldTransformers = new HashMap<String, NameTransformer>(2);
            }
            this.fieldTransformers.put(field, transformer);
        }
    }

    public HostMatcher getHostMatcher() {
        return this.hostMatcher;
    }

    public TypeMatcher getTypeMatcher() {
        return this.typeMatcher;
    }

    public FieldMatcher getFieldMatcher() {
        return this.fieldMatcher;
    }

    @Override
    public boolean matchesHost(DataSet data) {
        return this.hostMatcher.matchesHost(data);
    }

    @Override
    public List<DataSet> getMatchingHosts(Collection<DataSet> toMatch) {
        return this.hostMatcher.getMatchingHosts(toMatch);
    }

    @Override
    public List<DataType> getMatchingTypes(DataSet data) {
        return this.typeMatcher.getMatchingTypes(data);
    }

    @Override
    public List<String> getMatchingFields(DataType type) {
        return this.fieldMatcher.getMatchingFields(type);
    }

    @Override
    public String renameHost(DataSet data) {
        String hostname = data.getHostname();
        if (this.hostTransformers != null) {
            NameTransformer transformer = this.hostTransformers.get(hostname);
            if (transformer != null) {
                return transformer.transform(hostname);
            }
            transformer = this.hostTransformers.get(DEFAULT_NAME_TRANSFORMER_KEY);
            if (transformer != null) {
                return transformer.transform(hostname);
            }
            return hostname;
        }
        return hostname;
    }

    @Override
    public String renameType(DataType type) {
        String typeId = super.renameType(type);
        if (this.typeTransformers != null) {
            NameTransformer transformer = this.typeTransformers.get(typeId);
            if (transformer != null) {
                return transformer.transform(typeId);
            }
            transformer = this.typeTransformers.get(DEFAULT_NAME_TRANSFORMER_KEY);
            if (transformer != null) {
                return transformer.transform(typeId);
            }
            return typeId;
        }
        return typeId;
    }

    @Override
    public String renameField(String field) {
        field = super.renameField(field);
        if (this.fieldTransformers != null) {
            NameTransformer transformer = this.fieldTransformers.get(field);
            if (transformer != null) {
                return transformer.transform(field);
            }
            transformer = this.fieldTransformers.get(DEFAULT_NAME_TRANSFORMER_KEY);
            if (transformer != null) {
                return transformer.transform(field);
            }
            return field;
        }
        return field;
    }

    public DefaultDataDefinition withNewHosts(HostMatcher matcher) {
        if (matcher != null) {
            if (this.hostMatcher.equals(matcher)) {
                return this;
            }
            return new DefaultDataDefinition(matcher, this.typeMatcher, this.fieldMatcher, this.getStatistic(), this.usesSecondaryYAxis());
        }
        return this;
    }

    public DefaultDataDefinition withNewTypes(TypeMatcher matcher) {
        if (matcher != null) {
            if (this.typeMatcher.equals(matcher)) {
                return this;
            }
            return new DefaultDataDefinition(this.hostMatcher, matcher, this.fieldMatcher, this.getStatistic(), this.usesSecondaryYAxis());
        }
        return this;
    }

    public DefaultDataDefinition withNewFields(FieldMatcher matcher) {
        if (matcher != null) {
            if (this.fieldMatcher.equals(matcher)) {
                return this;
            }
            return new DefaultDataDefinition(this.hostMatcher, this.typeMatcher, matcher, this.getStatistic(), this.usesSecondaryYAxis());
        }
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(256);
        builder.append('{');
        builder.append("host: ");
        builder.append("match=");
        builder.append(this.hostMatcher);
        if (this.hostTransformers != null) {
            builder.append(", ");
            builder.append("transforms=");
            builder.append(this.hostTransformers);
        }
        builder.append("; ");
        builder.append("type: ");
        builder.append("match=");
        builder.append(this.typeMatcher);
        if (this.typeTransformers != null) {
            builder.append(", ");
            builder.append("transforms=");
            builder.append(this.typeTransformers);
        }
        builder.append("; ");
        builder.append("field: ");
        builder.append("match=");
        builder.append(this.fieldMatcher);
        if (this.fieldTransformers != null) {
            builder.append(", ");
            builder.append("transforms=");
            builder.append(this.fieldTransformers);
        }
        if (!Statistic.AVERAGE.equals((Object)this.getStatistic())) {
            builder.append("; ");
            builder.append("stat=");
            builder.append((Object)this.getStatistic());
        }
        builder.append('}');
        return builder.toString();
    }
}

