/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.definition;

import com.ibm.nmon.analysis.Statistic;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.definition.DataDefinition;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ExactDataDefinition
extends DataDefinition {
    private final List<DataSet> dataSets;
    private final List<DataType> types;
    private final List<String> fields;

    public ExactDataDefinition(DataSet data, DataType type, List<String> fields, Statistic stat, boolean useSecondaryYAxis) {
        super(stat, useSecondaryYAxis);
        this.dataSets = Collections.singletonList(data);
        this.types = Collections.singletonList(type);
        this.fields = fields;
    }

    public ExactDataDefinition(DataSet data, DataType type, List<String> fields) {
        this.dataSets = Collections.singletonList(data);
        this.types = Collections.singletonList(type);
        this.fields = fields;
    }

    public DataSet getDataSet() {
        return this.dataSets.get(0);
    }

    public DataType getDataType() {
        return this.types.get(0);
    }

    @Override
    public boolean matchesHost(DataSet data) {
        return data.equals(this.dataSets.get(0));
    }

    @Override
    public List<DataSet> getMatchingHosts(Collection<DataSet> toMatch) {
        return this.dataSets;
    }

    @Override
    public List<DataType> getMatchingTypes(DataSet data) {
        return this.types;
    }

    @Override
    public List<String> getMatchingFields(DataType type) {
        return this.fields;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append('{');
        builder.append("data: ");
        builder.append(this.dataSets);
        builder.append("; ");
        builder.append("types: ");
        builder.append(this.types);
        builder.append("; ");
        builder.append("fields: ");
        builder.append(this.fields);
        builder.append('}');
        return builder.toString();
    }
}

