/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.matcher;

import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.matcher.FieldMatcher;
import com.ibm.nmon.util.DataHelper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiskMatcher
implements FieldMatcher {
    private static final Logger logger = LoggerFactory.getLogger(DiskMatcher.class);
    public static final DiskMatcher INSTANCE = new DiskMatcher();

    private DiskMatcher() {
    }

    @Override
    public List<String> getMatchingFields(DataType type) {
        ArrayList<String> fields = new ArrayList<String>(type.getFieldCount() / 2);
        if (!type.getId().startsWith("DISK")) {
            logger.warn("specified disks for a non-disk data type {}, ignoring", (Object)type);
        } else {
            for (String field : type.getFields()) {
                if (!DataHelper.isNotPartition(field)) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    public String toString() {
        return "$DISKS";
    }
}

