/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.matcher;

import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.matcher.FieldMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ExactFieldMatcher
implements FieldMatcher {
    private final String field;

    public ExactFieldMatcher(String field) {
        if (field == null || "".equals(field)) {
            throw new IllegalArgumentException("field cannot be null");
        }
        this.field = field;
    }

    public String getField() {
        return this.field;
    }

    @Override
    public List<String> getMatchingFields(DataType type) {
        if (type == null) {
            return Collections.emptyList();
        }
        ArrayList<String> toReturn = new ArrayList<String>(type.getFieldCount());
        for (String field : type.getFields()) {
            if (!this.field.equals(field)) continue;
            toReturn.add(field);
        }
        return toReturn;
    }

    public String toString() {
        return this.field;
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ExactFieldMatcher) {
            ExactFieldMatcher matcher = (ExactFieldMatcher)obj;
            return this.field.equals(matcher.field);
        }
        return false;
    }
}

