/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.matcher;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.matcher.HostMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ExactHostMatcher
implements HostMatcher {
    private final String hostname;

    public ExactHostMatcher(String hostname) {
        if (hostname == null || "".equals(hostname)) {
            throw new IllegalArgumentException("hostname cannot be null");
        }
        this.hostname = hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    @Override
    public boolean matchesHost(DataSet data) {
        return data.getHostname().equals(this.hostname);
    }

    @Override
    public List<DataSet> getMatchingHosts(Collection<DataSet> toMatch) {
        if (toMatch == null || toMatch.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DataSet> toReturn = new ArrayList<DataSet>(toMatch.size());
        for (DataSet data : toMatch) {
            if (!data.getHostname().equals(this.hostname)) continue;
            toReturn.add(data);
        }
        return toReturn;
    }

    public String toString() {
        return this.hostname;
    }

    public int hashCode() {
        return this.hostname.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ExactHostMatcher) {
            ExactHostMatcher matcher = (ExactHostMatcher)obj;
            return this.hostname.equals(matcher.hostname);
        }
        return false;
    }
}

