/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.matcher;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.matcher.TypeMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ExactTypeMatcher
implements TypeMatcher {
    private final String type;

    public ExactTypeMatcher(String type) {
        if (type == null || "".equals(type)) {
            throw new IllegalArgumentException("type cannot be null");
        }
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public List<DataType> getMatchingTypes(DataSet data) {
        if (data == null || data.getTypeCount() == 0) {
            return Collections.emptyList();
        }
        ArrayList<DataType> toReturn = new ArrayList<DataType>(data.getTypeCount());
        for (DataType toCompare : data.getTypes()) {
            if (!this.type.equals(toCompare.toString())) continue;
            toReturn.add(toCompare);
        }
        return toReturn;
    }

    public String toString() {
        return this.type;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ExactTypeMatcher) {
            ExactTypeMatcher matcher = (ExactTypeMatcher)obj;
            return this.type.equals(matcher.type);
        }
        return false;
    }
}

