/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.matcher;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.matcher.HostMatcher;
import com.ibm.nmon.data.matcher.SimpleHostMatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class OSMatcher
extends SimpleHostMatcher {
    private final HostMatcher matcher;
    private static final HostMatcher LINUX = new SimpleHostMatcher("linux"){

        @Override
        public boolean matchesHost(DataSet data) {
            return this.getMetadata(data, "OS").contains("linux");
        }
    };
    private static final HostMatcher AIX = new SimpleHostMatcher("aix"){

        @Override
        public boolean matchesHost(DataSet data) {
            return !this.getMetadata(data, "AIX").equals("");
        }
    };
    private static final HostMatcher VIOS = new SimpleHostMatcher("vios"){

        @Override
        public boolean matchesHost(DataSet data) {
            return !this.getMetadata(data, "VIOS").equals("");
        }
    };
    private static final HostMatcher UNIX = new SimpleHostMatcher("unix"){

        @Override
        public boolean matchesHost(DataSet data) {
            return LINUX.matchesHost(data) || AIX.matchesHost(data) || VIOS.matchesHost(data);
        }
    };
    private static final HostMatcher PERFMON = new SimpleHostMatcher("perfmon"){

        @Override
        public boolean matchesHost(DataSet data) {
            return this.getMetadata(data, "OS").equals("perfmon");
        }
    };
    private static final HostMatcher UNKNOWN = new HostMatcher(){

        @Override
        public boolean matchesHost(DataSet data) {
            return false;
        }

        @Override
        public List<DataSet> getMatchingHosts(Collection<DataSet> toMatch) {
            return Collections.emptyList();
        }

        public String toString() {
            return "unknown";
        }
    };

    public OSMatcher(String operatingSystem) {
        super("os");
        if (operatingSystem == null || "".equals(operatingSystem)) {
            throw new IllegalArgumentException("operatingSystem cannot be null");
        }
        this.matcher = (operatingSystem = operatingSystem.toLowerCase()).contains("linux") ? LINUX : (operatingSystem.contains("aix") ? AIX : (operatingSystem.contains("vios") ? VIOS : (operatingSystem.contains("unix") ? UNIX : (operatingSystem.contains("perfmon") ? PERFMON : UNKNOWN))));
    }

    @Override
    public boolean matchesHost(DataSet data) {
        return this.matcher.matchesHost(data);
    }

    @Override
    public String toString() {
        return this.matcher.toString();
    }

    public int hashCode() {
        return this.matcher.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof OSMatcher) {
            OSMatcher matcher = (OSMatcher)obj;
            return this.matcher == matcher.matcher;
        }
        return false;
    }
}

