/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.matcher;

import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.matcher.FieldMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegexFieldMatcher
implements FieldMatcher {
    private final Matcher matcher;

    public RegexFieldMatcher(String regex) {
        this.matcher = Pattern.compile(regex).matcher("");
    }

    @Override
    public List<String> getMatchingFields(DataType type) {
        if (type == null) {
            return Collections.emptyList();
        }
        ArrayList<String> toReturn = new ArrayList<String>(type.getFieldCount());
        for (String field : type.getFields()) {
            if (!this.matcher.reset(field).matches()) continue;
            toReturn.add(field);
        }
        return toReturn;
    }

    public String toString() {
        return this.matcher.pattern().pattern();
    }

    public int hashCode() {
        return this.matcher.pattern().pattern().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RegexFieldMatcher) {
            RegexFieldMatcher matcher = (RegexFieldMatcher)obj;
            return this.matcher.pattern().pattern().equals(matcher.matcher.pattern().pattern());
        }
        return false;
    }
}

