/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.matcher;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.matcher.HostMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegexHostMatcher
implements HostMatcher {
    private final Matcher matcher;

    public RegexHostMatcher(String regex) {
        this.matcher = Pattern.compile(regex).matcher("");
    }

    @Override
    public boolean matchesHost(DataSet data) {
        return this.matcher.reset(data.getHostname()).matches();
    }

    @Override
    public List<DataSet> getMatchingHosts(Collection<DataSet> toMatch) {
        if (toMatch == null || toMatch.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DataSet> toReturn = new ArrayList<DataSet>(toMatch.size());
        for (DataSet data : toMatch) {
            if (!this.matcher.reset(data.getHostname()).matches()) continue;
            toReturn.add(data);
        }
        return toReturn;
    }

    public String toString() {
        return this.matcher.pattern().pattern();
    }

    public int hashCode() {
        return this.matcher.pattern().pattern().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RegexHostMatcher) {
            RegexHostMatcher matcher = (RegexHostMatcher)obj;
            return this.matcher.pattern().pattern().equals(matcher.matcher.pattern().pattern());
        }
        return false;
    }
}

