/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.matcher;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.matcher.TypeMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegexTypeMatcher
implements TypeMatcher {
    private final Matcher matcher;

    public RegexTypeMatcher(String regex) {
        this.matcher = Pattern.compile(regex).matcher("");
    }

    @Override
    public List<DataType> getMatchingTypes(DataSet data) {
        if (data == null || data.getTypeCount() == 0) {
            return Collections.emptyList();
        }
        ArrayList<DataType> toReturn = new ArrayList<DataType>(data.getTypeCount());
        for (DataType type : data.getTypes()) {
            if (!this.matcher.reset(type.toString()).matches()) continue;
            toReturn.add(type);
        }
        return toReturn;
    }

    public String toString() {
        return this.matcher.pattern().pattern();
    }

    public int hashCode() {
        return this.matcher.pattern().pattern().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RegexTypeMatcher) {
            RegexTypeMatcher matcher = (RegexTypeMatcher)obj;
            return this.matcher.pattern().pattern().equals(matcher.matcher.pattern().pattern());
        }
        return false;
    }
}

