/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.matcher;

import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.matcher.FieldMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class SetFieldMatcher
implements FieldMatcher {
    private final List<String> fields;

    public SetFieldMatcher(String ... fields) {
        if (fields == null || fields.length == 0) {
            throw new IllegalArgumentException("fields cannot be empty");
        }
        ArrayList<String> temp = new ArrayList<String>(Arrays.asList(fields));
        this.fields = Collections.unmodifiableList(temp);
    }

    @Override
    public List<String> getMatchingFields(DataType type) {
        if (type == null) {
            return Collections.emptyList();
        }
        ArrayList<String> toReturn = new ArrayList<String>(type.getFieldCount());
        for (String field : this.fields) {
            if (!type.hasField(field)) continue;
            toReturn.add(field);
        }
        return toReturn;
    }

    public String toString() {
        return this.fields.toString();
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SetFieldMatcher) {
            SetFieldMatcher matcher = (SetFieldMatcher)obj;
            return this.fields.equals(matcher.fields);
        }
        return false;
    }
}

