/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.matcher;

import com.ibm.nmon.data.BasicDataSet;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.NMONDataSet;
import com.ibm.nmon.data.PerfmonDataSet;
import com.ibm.nmon.data.SystemDataSet;
import com.ibm.nmon.data.matcher.HostMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

abstract class SimpleHostMatcher
implements HostMatcher {
    private String name;

    SimpleHostMatcher(String name) {
        this.name = name;
    }

    @Override
    public List<DataSet> getMatchingHosts(Collection<DataSet> toMatch) {
        ArrayList<DataSet> toReturn = new ArrayList<DataSet>(toMatch.size());
        for (DataSet data : toMatch) {
            if (!this.matchesHost(data)) continue;
            toReturn.add(data);
        }
        return toReturn;
    }

    protected final String getMetadata(DataSet data, String key) {
        String value = null;
        if (data.getClass().equals(BasicDataSet.class)) {
            value = ((BasicDataSet)data).getMetadata(key);
        } else if (data.getClass().equals(NMONDataSet.class)) {
            value = ((NMONDataSet)data).getMetadata(key);
        } else if (data.getClass().equals(PerfmonDataSet.class)) {
            value = ((PerfmonDataSet)data).getMetadata(key);
        } else if (data.getClass().equals(SystemDataSet.class)) {
            long time;
            Map<String, String> metadata;
            SystemDataSet systemData = (SystemDataSet)data;
            Iterator<Long> i$ = systemData.getMetadataTimes().iterator();
            while (i$.hasNext() && ((metadata = systemData.getMetadata(time = i$.next().longValue())) == null || (value = metadata.get(key)) == null)) {
            }
        }
        if (value == null) {
            value = "";
        }
        return value.toLowerCase();
    }

    public String toString() {
        return this.name;
    }
}

