/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.transform;

import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.transform.DataTransform;

public final class AIXLPARTransform
implements DataTransform {
    @Override
    public DataType buildDataType(String id, String subId, String name, String ... fields) {
        String[] newFields = new String[fields.length + 2];
        int i = 0;
        int j = 0;
        while (i < fields.length) {
            String field = fields[i];
            if ("EC_Idle%".equals(field)) {
                newFields[j] = "EC_CPU%";
            } else if ("VP_Idle%".equals(field)) {
                newFields[j] = "VP_CPU%";
            } else if ("Folded".equals(field)) {
                newFields[j] = field;
                newFields[++j] = "Unfolded";
            } else {
                newFields[j] = field;
            }
            ++i;
            ++j;
        }
        newFields[newFields.length - 1] = "OtherLPARs";
        return new DataType(id, name, newFields);
    }

    @Override
    public double[] transform(DataType type, double[] data) {
        double[] newData = new double[type.getFieldCount()];
        int i = 0;
        int j = 0;
        while (i < data.length) {
            String field = type.getField(j);
            if (field.equals("EC_CPU%")) {
                newData[j] = data[type.getFieldIndex("EC_User%")] + data[type.getFieldIndex("EC_Sys%")];
            } else if (field.equals("VP_CPU%")) {
                newData[j] = data[type.getFieldIndex("VP_User%")] + data[type.getFieldIndex("VP_Sys%")];
            } else if (field.equals("Unfolded")) {
                newData[j] = data[type.getFieldIndex("virtualCPUs")] - data[type.getFieldIndex("Folded")];
                --i;
            } else {
                newData[j] = data[i];
            }
            ++i;
            ++j;
        }
        newData[newData.length - 1] = data[type.getFieldIndex("poolCPUs")] - data[type.getFieldIndex("PoolIdle")] - data[type.getFieldIndex("PhysicalCPU")];
        return newData;
    }

    @Override
    public boolean isValidFor(String typeId, String subId) {
        return "LPAR".equals(typeId);
    }
}

