/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.transform;

import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.transform.DataTransform;

public final class CPUBusyTransform
implements DataTransform {
    @Override
    public DataType buildDataType(String id, String subId, String name, String ... fields) {
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if ("Idle%".equals(field)) {
                fields[i] = "CPU%";
                continue;
            }
            if (!"PhysicalCPUs".equals(field)) continue;
            fields[i] = "CPUs";
        }
        return new DataType(id, name, fields);
    }

    @Override
    public double[] transform(DataType type, double[] data) {
        int idx = type.getFieldIndex("CPU%");
        data[idx] = data[type.getFieldIndex("User%")] + data[type.getFieldIndex("Sys%")];
        return data;
    }

    @Override
    public boolean isValidFor(String typeId, String subId) {
        return typeId.startsWith("CPU");
    }
}

