/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.transform;

import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.transform.DataTransform;
import com.ibm.nmon.util.DataHelper;

public final class DiskTotalTransform
implements DataTransform {
    @Override
    public DataType buildDataType(String id, String subId, String name, String ... fields) {
        String[] newFields = new String[fields.length + 1];
        System.arraycopy(fields, 0, newFields, 0, fields.length);
        newFields[fields.length] = "Total";
        return new DataType(id, name, newFields);
    }

    @Override
    public double[] transform(DataType type, double[] data) {
        double[] newData = new double[data.length + 1];
        System.arraycopy(data, 0, newData, 0, data.length);
        double total = 0.0;
        for (String field : type.getFields()) {
            if (!DataHelper.isNotPartition(field)) continue;
            int idx = type.getFieldIndex(field);
            if (idx >= data.length) break;
            total += data[idx];
        }
        newData[data.length] = total;
        return newData;
    }

    @Override
    public boolean isValidFor(String typeId, String subId) {
        return typeId.startsWith("DISK") && !typeId.equals("DISKBUSY");
    }
}

