/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.transform;

import com.ibm.nmon.data.DataRecord;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.transform.DataPostProcessor;
import com.ibm.nmon.util.DataHelper;

public final class EthernetTotalPostProcessor
implements DataPostProcessor {
    private final String typePrefix;

    public EthernetTotalPostProcessor(String typePrefix) {
        if (typePrefix == null || typePrefix.equals("")) {
            throw new IllegalArgumentException("typePrefix cannot be null");
        }
        this.typePrefix = typePrefix;
    }

    @Override
    public void addDataTypes(DataSet data) {
        DataType net = data.getType(this.typePrefix);
        if (net == null) {
            return;
        }
        DataType error = data.getType(this.typePrefix + "ERROR");
        DataType packet = data.getType(this.typePrefix + "PACKET");
        DataType size = data.getType(this.typePrefix + "SIZE");
        boolean hasErrors = error != null;
        boolean hasPackets = packet != null;
        boolean hasSize = size != null;
        int ethernetFieldCount = 3 + (hasErrors ? 4 : 0) + (hasPackets ? 3 : 0) + (hasSize ? 3 : 0);
        int n = 0;
        String[] ethernetFields = new String[ethernetFieldCount];
        ethernetFields[n++] = "total-read-KB/s";
        ethernetFields[n++] = "total-write-KB/s";
        ethernetFields[n++] = "total-KB/s";
        if (hasErrors) {
            ethernetFields[n++] = "total-ierrs";
            ethernetFields[n++] = "total-oerrs";
            ethernetFields[n++] = "total-collisions";
            ethernetFields[n++] = "total-errs";
        }
        if (hasPackets) {
            ethernetFields[n++] = "total-read-packets/s";
            ethernetFields[n++] = "total-write-packets/s";
            ethernetFields[n++] = "total-packets/s";
        }
        if (hasSize) {
            ethernetFields[n++] = "total-readsize";
            ethernetFields[n++] = "total-writesize";
            ethernetFields[n++] = "total-size";
        }
        data.addType(new DataType(this.typePrefix + "ETOTAL", this.typePrefix + " Ethernet grand totals", ethernetFields));
    }

    @Override
    public void postProcess(DataSet data, DataRecord record) {
        DataType net = data.getType(this.typePrefix);
        if (net == null) {
            return;
        }
        if (!record.hasData(net)) {
            return;
        }
        DataType ethernet = data.getType(this.typePrefix + "ETOTAL");
        DataType error = data.getType(this.typePrefix + "ERROR");
        DataType packet = data.getType(this.typePrefix + "PACKET");
        DataType size = data.getType(this.typePrefix + "SIZE");
        boolean hasErrors = error != null;
        boolean hasPackets = packet != null;
        boolean hasSize = size != null;
        double[] ethernetData = new double[ethernet.getFieldCount()];
        int n = 0;
        for (String iface : DataHelper.getInterfaces(net)) {
            n = 0;
            if (!iface.startsWith("eth") && !iface.startsWith("en")) continue;
            double read = record.getData(net, iface + "-read-KB/s");
            double write = record.getData(net, iface + "-write-KB/s");
            int n2 = n++;
            ethernetData[n2] = ethernetData[n2] + read;
            int n3 = n++;
            ethernetData[n3] = ethernetData[n3] + write;
            int n4 = n++;
            ethernetData[n4] = ethernetData[n4] + (read + write);
            if (hasErrors) {
                double ierrs = record.getData(error, iface + "-ierrs");
                double oerrs = record.getData(error, iface + "-oerrs");
                double collisions = record.getData(error, iface + "-collisions");
                int n5 = n++;
                ethernetData[n5] = ethernetData[n5] + ierrs;
                int n6 = n++;
                ethernetData[n6] = ethernetData[n6] + oerrs;
                int n7 = n++;
                ethernetData[n7] = ethernetData[n7] + collisions;
                int n8 = n++;
                ethernetData[n8] = ethernetData[n8] + (ierrs + oerrs + collisions);
            }
            if (hasPackets) {
                read = record.getData(packet, iface + "-reads/s");
                write = record.getData(packet, iface + "-writes/s");
                int n9 = n++;
                ethernetData[n9] = ethernetData[n9] + read;
                int n10 = n++;
                ethernetData[n10] = ethernetData[n10] + write;
                int n11 = n++;
                ethernetData[n11] = ethernetData[n11] + (read + write);
            }
            if (!hasSize) continue;
            read = record.getData(size, iface + "-readsize");
            write = record.getData(size, iface + "-writesize");
            int n12 = n++;
            ethernetData[n12] = ethernetData[n12] + read;
            int n13 = n++;
            ethernetData[n13] = ethernetData[n13] + write;
            int n14 = n++;
            ethernetData[n14] = ethernetData[n14] + (read + write);
        }
        record.addData(ethernet, ethernetData);
    }
}

