/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.transform;

import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.transform.DataTransform;

public final class LinuxMemoryTransform
implements DataTransform {
    @Override
    public DataType buildDataType(String id, String subId, String name, String ... fields) {
        String[] newFields = new String[fields.length + 1];
        System.arraycopy(fields, 0, newFields, 0, fields.length);
        newFields[fields.length] = "swapused";
        return new DataType(id, name, newFields);
    }

    @Override
    public double[] transform(DataType type, double[] data) {
        double[] newData = new double[data.length + 1];
        System.arraycopy(data, 0, newData, 0, data.length);
        int swaptotal = type.getFieldIndex("swaptotal");
        int swapfree = type.getFieldIndex("swapfree");
        newData[data.length] = newData[swaptotal] - newData[swapfree];
        return newData;
    }

    @Override
    public boolean isValidFor(String typeId, String subId) {
        return "MEM".equals(typeId);
    }
}

