/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.transform;

import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.SubDataType;
import com.ibm.nmon.data.transform.DataTransform;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WindowsBytesTransform
implements DataTransform {
    private static final Matcher VALID_TYPES = Pattern.compile("LogicalDisk.*|PhysicalDisk.*|Network Interface.*|Memory|System").matcher("");
    private static final Matcher VALID_FIELDS = Pattern.compile("(.*?[^KM])?Bytes(.*)").matcher("");
    private Map<String, Set<Integer>> changedFields = new HashMap<String, Set<Integer>>();

    @Override
    public DataType buildDataType(String id, String subId, String name, String ... fields) {
        HashSet<Integer> changes = new HashSet<Integer>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            VALID_FIELDS.reset(fields[i]);
            if (!VALID_FIELDS.matches()) continue;
            fields[i] = "Memory".equals(id) ? VALID_FIELDS.replaceAll("$1MB$2") : VALID_FIELDS.replaceAll("$1KB$2");
            changes.add(i);
        }
        this.changedFields.put(name, changes);
        if (subId != null) {
            return new SubDataType(id, subId, name, fields);
        }
        return new DataType(id, name, fields);
    }

    @Override
    public double[] transform(DataType type, double[] data) {
        Set<Integer> changes = this.changedFields.get(type.getName());
        if (changes != null) {
            for (int i = 0; i < data.length; ++i) {
                if (!changes.contains(i)) continue;
                if ("Memory".equals(type.getId())) {
                    int n = i;
                    data[n] = data[n] / 1048576.0;
                    continue;
                }
                int n = i;
                data[n] = data[n] / 1024.0;
            }
        }
        return data;
    }

    @Override
    public boolean isValidFor(String typeId, String subId) {
        return VALID_TYPES.reset(typeId).matches();
    }

    public void reset() {
        this.changedFields.clear();
    }
}

