/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.transform;

import com.ibm.nmon.data.DataRecord;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.SubDataType;
import com.ibm.nmon.data.transform.DataPostProcessor;

public final class WindowsNetworkPostProcessor
implements DataPostProcessor {
    @Override
    public void addDataTypes(DataSet data) {
        SubDataType total = null;
        for (DataType type : data.getTypes()) {
            if (!type.getId().contains("Network Interface")) continue;
            total = new SubDataType("Network Interface", "Total", "Network Interface", type.getFields().toArray(new String[type.getFieldCount()]));
            break;
        }
        if (total != null) {
            data.addType(total);
        }
    }

    @Override
    public void postProcess(DataSet data, DataRecord record) {
        DataType total = data.getType("Network Interface (Total)");
        if (total == null) {
            return;
        }
        int totalFieldCount = total.getFieldCount();
        double[] totalData = new double[totalFieldCount];
        for (int i = 0; i < totalData.length; ++i) {
            totalData[i] = 0.0;
        }
        for (DataType type : data.getTypes()) {
            if (!type.getId().startsWith("Network Interface") || type == total || !record.hasData(type)) continue;
            double[] typeData = record.getData(type);
            for (int i = 0; i < totalFieldCount; ++i) {
                int n = i;
                totalData[n] = totalData[n] + typeData[i];
            }
        }
        record.addData(total, totalData);
    }
}

