/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.transform;

import com.ibm.nmon.data.DataRecord;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.data.Process;
import com.ibm.nmon.data.ProcessDataSet;
import com.ibm.nmon.data.ProcessDataType;
import com.ibm.nmon.data.SubDataType;
import com.ibm.nmon.data.transform.DataPostProcessor;
import java.util.ArrayList;
import java.util.List;

public class WindowsProcessPostProcessor
implements DataPostProcessor {
    private final List<DataType> processors = new ArrayList<DataType>(8);

    @Override
    public void addDataTypes(DataSet data) {
        this.processors.clear();
        for (DataType type : data.getTypes()) {
            SubDataType subType;
            if (!(type instanceof SubDataType) || !(subType = (SubDataType)type).getPrimaryId().equals("Processor") || subType.getSubId().equals("Total")) continue;
            this.processors.add(type);
        }
    }

    @Override
    public void postProcess(DataSet data, DataRecord record) {
        if (data instanceof ProcessDataSet) {
            ProcessDataSet processData = (ProcessDataSet)data;
            int processorCount = 0;
            if (this.processors.isEmpty()) {
                return;
            }
            for (DataType processorType : this.processors) {
                if (!record.hasData(processorType)) continue;
                ++processorCount;
            }
            for (Process process : processData.getProcesses()) {
                ProcessDataType processType = processData.getType(process);
                if (!record.hasData(processType)) continue;
                for (String field : processType.getFields()) {
                    if (!field.startsWith("%")) continue;
                    double[] dArray = record.getData(processType);
                    int n = processType.getFieldIndex(field);
                    dArray[n] = dArray[n] / (double)processorCount;
                }
            }
        }
    }
}

