/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.transform.name;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.matcher.HostMatcher;
import com.ibm.nmon.data.transform.name.LPARNameTransformer;
import com.ibm.nmon.data.transform.name.NMONRunNameTransformer;
import com.ibm.nmon.data.transform.name.NameTransformer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HostRenamer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostRenamer.class);
    private final List<HostMatcher> matchers;
    private final List<NameTransformer> transformers;
    public static final HostRenamer BY_LPAR = new HostRenamer(HostMatcher.ALL, new LPARNameTransformer(null));
    public static final HostRenamer BY_RUN = new HostRenamer(HostMatcher.ALL, new NMONRunNameTransformer(null));
    public static final HostRenamer BY_HOST = new HostRenamer(HostMatcher.ALL, new NameTransformer(){

        @Override
        public String transform(String original) {
            return original;
        }

        public String toString() {
            return "hostname";
        }
    });

    public HostRenamer() {
        this.matchers = new LinkedList<HostMatcher>();
        this.transformers = new LinkedList<NameTransformer>();
    }

    private HostRenamer(HostMatcher matcher, NameTransformer renamer) {
        this.matchers = Collections.singletonList(matcher);
        this.transformers = Collections.singletonList(renamer);
    }

    public void addRenamer(HostMatcher matcher, NameTransformer renamer) {
        if (matcher != null && renamer != null) {
            this.matchers.add(matcher);
            this.transformers.add(renamer);
        }
    }

    public void rename(DataSet data) {
        int n = 0;
        for (HostMatcher matcher : this.matchers) {
            if (matcher.matchesHost(data)) {
                NameTransformer transformer = this.transformers.get(n);
                if (LPARNameTransformer.class.equals(transformer.getClass())) {
                    transformer = new LPARNameTransformer(data);
                } else if (NMONRunNameTransformer.class.equals(transformer.getClass())) {
                    transformer = new NMONRunNameTransformer(data);
                }
                String newHostname = transformer.transform(data.getHostname());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("renaming '{}' to '{}' with '{}'", new Object[]{data.getHostname(), newHostname, transformer});
                }
                data.setHostname(newHostname);
                break;
            }
            LOGGER.trace("'{}' does not match '{}'", (Object)matcher, (Object)data);
            ++n;
        }
    }
}

