/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.transform.name;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.nmon.data.matcher.ExactHostMatcher;
import com.ibm.nmon.data.matcher.HostMatcher;
import com.ibm.nmon.data.matcher.RegexHostMatcher;
import com.ibm.nmon.data.transform.name.HostRenamer;
import com.ibm.nmon.data.transform.name.LPARNameTransformer;
import com.ibm.nmon.data.transform.name.NMONRunNameTransformer;
import com.ibm.nmon.data.transform.name.NameTransformer;
import com.ibm.nmon.data.transform.name.RegexNameTransformer;
import com.ibm.nmon.data.transform.name.SimpleNameTransformer;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HostRenamerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostRenamerFactory.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static HostRenamer loadFromFile(File file) throws IOException, IllegalArgumentException {
        List data = (List)MAPPER.readValue(file, (TypeReference)new TypeReference<List<Map<String, String>>>(){});
        HostRenamer renamer = new HostRenamer();
        for (Map map : data) {
            String alias = (String)map.get("alias");
            NameTransformer transformer = null;
            HostMatcher matcher = null;
            if (alias != null) {
                transformer = "$LPAR".equals(alias) ? new LPARNameTransformer(null) : ("$RUN".equals(alias) ? new NMONRunNameTransformer(null) : new SimpleNameTransformer(alias));
            } else {
                String regex = (String)map.get("aliasRegex");
                if (regex == null) {
                    regex = (String)map.get("regex");
                }
                if (regex != null) {
                    String group = (String)map.get("aliasByGroup");
                    if (group == null) {
                        String replacement = (String)map.get("aliasByReplacement");
                        transformer = replacement != null && !"".equals(replacement) ? new RegexNameTransformer(regex, replacement) : new RegexNameTransformer(regex);
                    } else {
                        try {
                            transformer = new RegexNameTransformer(regex, Integer.parseInt(group));
                        }
                        catch (NumberFormatException nfe) {
                            LOGGER.warn("'aliasByGroup' must be a number");
                            transformer = new RegexNameTransformer(regex);
                        }
                    }
                } else {
                    LOGGER.warn("either 'alias', 'aliasRegex' or 'regex' must be defined for each host");
                }
            }
            String name = (String)map.get("name");
            matcher = name != null ? new ExactHostMatcher(name) : ((name = (String)map.get("regex")) == null ? HostMatcher.ALL : new RegexHostMatcher(name));
            LOGGER.debug("will rename '{}' to '{}'", (Object)matcher, (Object)transformer);
            renamer.addRenamer(matcher, transformer);
        }
        return renamer;
    }

    private HostRenamerFactory() {
    }
}

