/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.transform.name;

import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.NMONDataSet;
import com.ibm.nmon.data.transform.name.NameTransformer;

public final class LPARNameTransformer
implements NameTransformer {
    private final NMONDataSet data;

    public LPARNameTransformer(DataSet data) {
        this.data = data != null && NMONDataSet.class.equals(data.getClass()) ? (NMONDataSet)data : null;
    }

    @Override
    public String transform(String original) {
        int idx;
        String lparstat;
        if (this.data == null) {
            return original;
        }
        NMONDataSet nmonData = this.data;
        if (nmonData.getMetadata("AIX") != null && (lparstat = nmonData.getSystemInfo("lparstat -i")) != null && (idx = lparstat.indexOf("Partition Name")) != -1) {
            idx = lparstat.indexOf(": ", idx);
            int end = lparstat.indexOf("\n", idx);
            return lparstat.substring(idx + 2, end);
        }
        return original;
    }

    public String toString() {
        return "LPAR name";
    }
}

