/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.data.transform.name;

import com.ibm.nmon.data.transform.name.NameTransformer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegexNameTransformer
implements NameTransformer {
    private static final Logger logger = LoggerFactory.getLogger(RegexNameTransformer.class);
    private final Matcher matcher;
    private final int group;
    private final String replacement;

    public RegexNameTransformer(String regex) {
        this(regex, 1);
    }

    public RegexNameTransformer(String regex, int group) {
        this.matcher = Pattern.compile(regex).matcher("");
        if (group < 0) {
            throw new IllegalArgumentException("group cannot be less than 0");
        }
        this.group = group;
        this.replacement = null;
    }

    public RegexNameTransformer(String regex, String replacement) {
        this.matcher = Pattern.compile(regex).matcher("");
        if (replacement == null || "".equals(replacement)) {
            throw new IllegalArgumentException("replacement string cannot be empty");
        }
        this.group = -1;
        this.replacement = replacement;
    }

    @Override
    public String transform(String original) {
        if (!this.matcher.reset(original).matches()) {
            logger.debug("regex '{}' does not match '{}'", (Object)this.matcher.pattern().pattern(), (Object)original);
            return original;
        }
        if (this.matcher.groupCount() == 0) {
            logger.warn("regex '{}' does not contain any groups", (Object)this.matcher);
            return original;
        }
        if (this.matcher.groupCount() < this.group) {
            logger.warn("regex '{}' only has {} groups, but {} was specified", new Object[]{this.matcher, this.matcher.groupCount(), this.group});
            return original;
        }
        if (this.replacement != null) {
            return this.matcher.replaceAll(this.replacement);
        }
        return this.matcher.group(this.group);
    }

    public String toString() {
        return this.matcher.pattern().pattern() + ';' + this.group;
    }
}

