/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.file;

import com.ibm.nmon.file.GCFileFilter;
import com.ibm.nmon.file.HATJFileFilter;
import com.ibm.nmon.file.IOStatFileFilter;
import com.ibm.nmon.file.JSONFileFilter;
import com.ibm.nmon.file.NMONFileFilter;
import com.ibm.nmon.file.PerfmonFileFilter;
import com.ibm.nmon.file.SwingAndIOFileFilter;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CombinedFileFilter
implements FileFilter {
    private final List<SwingAndIOFileFilter> filters = new ArrayList<SwingAndIOFileFilter>();
    private static final CombinedFileFilter INSTANCE = new CombinedFileFilter(false);
    private static final CombinedFileFilter INSTANCE_WITH_DIRECTORIES = new CombinedFileFilter(true);

    @Override
    public boolean accept(File pathname) {
        for (SwingAndIOFileFilter filter : this.filters) {
            if (!filter.accept(pathname)) continue;
            return true;
        }
        return false;
    }

    public Iterable<SwingAndIOFileFilter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public NMONFileFilter getNMONFileFilter() {
        return (NMONFileFilter)this.filters.get(0).getFilter();
    }

    public GCFileFilter getGCFileFilter() {
        return (GCFileFilter)this.filters.get(1).getFilter();
    }

    public IOStatFileFilter getIOStatFileFilter() {
        return (IOStatFileFilter)this.filters.get(2).getFilter();
    }

    public JSONFileFilter getJSONFileFilter() {
        return (JSONFileFilter)this.filters.get(3).getFilter();
    }

    public HATJFileFilter getHATJFileFilter() {
        return (HATJFileFilter)this.filters.get(4).getFilter();
    }

    public PerfmonFileFilter getPerfmonFileFilter() {
        return (PerfmonFileFilter)this.filters.get(5).getFilter();
    }

    private CombinedFileFilter(boolean acceptDirectories) {
        this.filters.add(new SwingAndIOFileFilter("NMON Files", new NMONFileFilter(), acceptDirectories));
        this.filters.add(new SwingAndIOFileFilter("Verbose GC Logs", new GCFileFilter(), acceptDirectories));
        this.filters.add(new SwingAndIOFileFilter("IOStat Files", new IOStatFileFilter(), acceptDirectories));
        this.filters.add(new SwingAndIOFileFilter("JSON Files", new JSONFileFilter(), acceptDirectories));
        this.filters.add(new SwingAndIOFileFilter("HATJ CSV Files", new HATJFileFilter(), acceptDirectories));
        this.filters.add(new SwingAndIOFileFilter("Perfmon CSV Files", new PerfmonFileFilter(), acceptDirectories));
    }

    public static CombinedFileFilter getInstance(boolean acceptDirectories) {
        if (acceptDirectories) {
            return INSTANCE_WITH_DIRECTORIES;
        }
        return INSTANCE;
    }
}

