/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.text.DecimalFormat;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;

public final class Styles {
    public static final String DATE_FORMAT_STRING = "HH:mm:ss MMM dd";
    public static final String DATE_FORMAT_STRING_SHORT = "HH:mm:ss";
    public static final String DATE_FORMAT_STRING_WITH_YEAR = "HH:mm:ss MMM dd yyyy";
    public static final String NUMBER_FORMAT_STRING = "#,##0.000";
    public static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("#,##0.000");
    public static final Font BOLD;
    public static final Font BOLD_ITALIC;
    public static final Font STRIKETHROUGH;
    public static final Font LABEL;
    public static final Font LABEL_ERROR;
    public static final Font TITLE;
    public static final Font ANNOTATION_FONT;
    public static final Border CONTENT_BORDER;
    public static final Border TITLE_BORDER;
    public static final Border LOWER_LINE_BORDER;
    public static final Border DOUBLE_LINE_BORDER;
    public static final Color ERROR_COLOR;
    public static final Color DEFAULT_COLOR;
    public static final Color ANNOTATION_COLOR;
    public static final BasicStroke ANNOTATION_STROKE;
    public static final ImageIcon IBM_ICON;
    public static final ImageIcon ADD_ICON;
    public static final ImageIcon COPY_ICON;
    public static final ImageIcon CLEAR_ICON;
    public static final ImageIcon SAVE_ICON;
    public static final ImageIcon INTERVAL_ICON;
    public static final ImageIcon REPORT_ICON;
    public static final ImageIcon COMPUTER_ICON;

    public static ImageIcon buildIcon(String image) {
        return new ImageIcon(Styles.class.getResource("/com/ibm/nmon/gui/icons/" + image));
    }

    public static Border createTopLineBorder(JComponent component) {
        return BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY), BorderFactory.createMatteBorder(1, 0, 0, 0, component.getBackground()));
    }

    public static Border createBottomLineBorder(JComponent component) {
        return BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY), BorderFactory.createMatteBorder(0, 0, 1, 0, component.getBackground()));
    }

    private Styles() {
    }

    static {
        CONTENT_BORDER = BorderFactory.createEmptyBorder(0, 5, 2, 2);
        TITLE_BORDER = BorderFactory.createEmptyBorder(5, 2, 5, 2);
        LOWER_LINE_BORDER = BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY);
        DOUBLE_LINE_BORDER = BorderFactory.createMatteBorder(1, 0, 1, 0, Color.LIGHT_GRAY);
        ERROR_COLOR = Color.RED;
        DEFAULT_COLOR = Color.BLACK;
        ANNOTATION_COLOR = new Color(0x222266);
        ANNOTATION_STROKE = new BasicStroke(0.6f, 0, 0, 1.0f, new float[]{1.0f, 2.0f, 5.0f, 2.0f}, 5.0f);
        IBM_ICON = Styles.buildIcon("ibmicon.png");
        ADD_ICON = Styles.buildIcon("add.png");
        COPY_ICON = Styles.buildIcon("page_copy.png");
        CLEAR_ICON = Styles.buildIcon("delete.png");
        SAVE_ICON = Styles.buildIcon("disk.png");
        INTERVAL_ICON = Styles.buildIcon("clock.png");
        REPORT_ICON = Styles.buildIcon("report_picture.png");
        COMPUTER_ICON = Styles.buildIcon("computer.png");
        Font defaultFont = UIManager.getDefaults().getFont("TextField.font");
        LABEL = defaultFont.deriveFont(1, (float)defaultFont.getSize() * 1.1f);
        LABEL_ERROR = LABEL.deriveFont(3);
        TITLE = defaultFont.deriveFont(1, (float)defaultFont.getSize() * 1.25f);
        BOLD = defaultFont.deriveFont(1);
        BOLD_ITALIC = defaultFont.deriveFont(3);
        Map<TextAttribute, ?> attributes = defaultFont.getAttributes();
        attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        STRIKETHROUGH = defaultFont.deriveFont(attributes);
        ANNOTATION_FONT = defaultFont;
    }
}

