/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.analysis;

import com.ibm.nmon.analysis.AnalysisSet;
import com.ibm.nmon.analysis.AnalysisSetListener;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.data.DataSetListener;
import com.ibm.nmon.data.DataType;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import com.ibm.nmon.gui.table.ChoosableColumnTableModel;
import java.util.LinkedList;
import java.util.List;

public abstract class AnalysisSetTableModel
extends ChoosableColumnTableModel
implements DataSetListener,
AnalysisSetListener {
    private static final long serialVersionUID = -8898709588877341715L;
    protected final NMONVisualizerGui gui;
    protected final AnalysisSet analysisSet;
    protected final List<String> keys = new LinkedList<String>();

    protected AnalysisSetTableModel(NMONVisualizerGui gui, AnalysisSet analysisSet) {
        this.gui = gui;
        this.analysisSet = analysisSet;
        gui.addDataSetListener(this);
        analysisSet.addListener(this);
    }

    public String getKey(int index) {
        return this.keys.get(index);
    }

    @Override
    public int getRowCount() {
        return this.keys.size();
    }

    @Override
    public final void analysisAdded(DataType type) {
        int startIdx = this.keys.size();
        for (String field : type.getFields()) {
            this.keys.add(type.getKey(field));
        }
        this.fireTableRowsInserted(startIdx, this.keys.size() - 1);
    }

    @Override
    public final void analysisAdded(DataType type, String field) {
        int startIdx = this.keys.size();
        this.keys.add(type.getKey(field));
        this.fireTableRowsInserted(startIdx, startIdx);
    }

    @Override
    public final void analysisRemoved(DataType type) {
        for (String field : type.getFields()) {
            this.analysisRemoved(type, field);
        }
    }

    @Override
    public final void analysisRemoved(DataType type, String field) {
        this.keys.remove(type.getKey(field));
        this.fireTableDataChanged();
    }

    @Override
    public final void analysisCleared() {
        this.keys.clear();
        this.fireTableDataChanged();
    }

    @Override
    public void dataAdded(DataSet data) {
        this.fireTableDataChanged();
    }

    @Override
    public void dataRemoved(DataSet data) {
        this.fireTableDataChanged();
    }

    @Override
    public void dataChanged(DataSet data) {
        this.fireTableDataChanged();
    }

    @Override
    public void dataCleared() {
        this.keys.clear();
        this.fireTableDataChanged();
    }
}

