/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.analysis;

import com.ibm.nmon.analysis.AnalysisSet;
import com.ibm.nmon.analysis.Statistic;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.gui.analysis.AnalysisSetTableModel;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public final class ByDataSetTableModel
extends AnalysisSetTableModel {
    private static final long serialVersionUID = 8726311839297203648L;
    private Statistic stat;
    private final List<String> columns;

    public ByDataSetTableModel(NMONVisualizerGui gui, AnalysisSet analysisSet) {
        super(gui, analysisSet);
        this.columns = new ArrayList<String>(2 + gui.getDataSetCount());
        this.rebuildColumns();
        this.buildColumnNameMap();
        this.stat = Statistic.AVERAGE;
        this.fireTableStructureChanged();
    }

    @Override
    public String[] getAllColumns() {
        return this.columns.toArray(new String[this.columns.size()]);
    }

    @Override
    public boolean getDefaultColumnState(int column) {
        return true;
    }

    @Override
    public boolean canDisableColumn(int column) {
        return column >= 2;
    }

    @Override
    protected Class<?> getEnabledColumnClass(int columnIndex) {
        if (columnIndex < 2) {
            return String.class;
        }
        if (Statistic.COUNT == this.stat) {
            return Integer.class;
        }
        return Double.class;
    }

    @Override
    protected String getEnabledColumnName(int column) {
        return this.columns.get(column);
    }

    @Override
    protected Object getEnabledValueAt(int rowIndex, int columnIndex) {
        String key = (String)this.keys.get(rowIndex);
        if (key == null) {
            throw new ArrayIndexOutOfBoundsException(rowIndex);
        }
        if (columnIndex == 0) {
            return this.analysisSet.getType(key);
        }
        if (columnIndex == 1) {
            return this.analysisSet.getField(key);
        }
        int n = 2;
        DataSet data = null;
        for (DataSet dataSet : this.gui.getDataSets()) {
            if (n++ != columnIndex) continue;
            data = dataSet;
            break;
        }
        if (data == null) {
            throw new ArrayIndexOutOfBoundsException(columnIndex);
        }
        return this.stat.getValue(this.gui.getAnalysis(data), this.analysisSet.getType(key), this.analysisSet.getField(key));
    }

    public void setStatistic(Statistic stat) {
        this.stat = stat;
        this.fireTableDataChanged();
    }

    @Override
    public void dataAdded(DataSet data) {
        this.rebuildColumns();
    }

    @Override
    public void dataRemoved(DataSet data) {
        this.rebuildColumns();
    }

    @Override
    public void dataCleared() {
        super.dataCleared();
        this.rebuildColumns();
    }

    private void rebuildColumns() {
        this.columns.clear();
        this.columns.add("Data Type");
        this.columns.add("Metric");
        for (DataSet dataSet : this.gui.getDataSets()) {
            this.columns.add(dataSet.getHostname());
        }
        BitSet oldEnabled = this.enabledColumns;
        this.enabledColumns = new BitSet(this.columns.size());
        if (oldEnabled != null) {
            int n = Math.min(oldEnabled.length(), this.columns.size());
            for (int i = 0; i < n; ++i) {
                this.enabledColumns.set(i, oldEnabled.get(i));
            }
            this.enabledColumns.set(this.columns.size() - 1, true);
        } else {
            this.enabledColumns.set(0, this.columns.size(), true);
        }
        this.buildColumnNameMap();
        this.fireTableStructureChanged();
    }
}

