/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nmon.gui.analysis;

import com.ibm.nmon.analysis.AnalysisSet;
import com.ibm.nmon.analysis.Statistic;
import com.ibm.nmon.data.DataSet;
import com.ibm.nmon.gui.analysis.AnalysisSetTableModel;
import com.ibm.nmon.gui.main.NMONVisualizerGui;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.BitSet;

public final class ByStatisticTableModel
extends AnalysisSetTableModel
implements PropertyChangeListener {
    private static final long serialVersionUID = 2863125593272808676L;
    private static final String[] COLUMN_NAMES = new String[]{"Hostname", "Data Type", "Metric", Statistic.MINIMUM.toString(), Statistic.AVERAGE.toString(), Statistic.MAXIMUM.toString(), Statistic.STD_DEV.toString(), Statistic.MEDIAN.toString(), Statistic.SUM.toString(), Statistic.COUNT.toString(), null};
    private static final boolean[] DEFAULT_COLUMNS = new boolean[]{true, true, true, true, true, true, true, false, false, false, false};

    public ByStatisticTableModel(NMONVisualizerGui gui, AnalysisSet analysisSet) {
        super(gui, analysisSet);
        ByStatisticTableModel.COLUMN_NAMES[ByStatisticTableModel.COLUMN_NAMES.length - 1] = Statistic.GRANULARITY_MAXIMUM.getName(gui.getGranularity());
        this.buildColumnNameMap();
        this.enabledColumns = new BitSet(COLUMN_NAMES.length);
        for (int i = 0; i < DEFAULT_COLUMNS.length; ++i) {
            this.enabledColumns.set(i, DEFAULT_COLUMNS[i]);
        }
        this.fireTableStructureChanged();
    }

    @Override
    public String getKey(int index) {
        int keyIndex = index / this.gui.getDataSetCount();
        return (String)this.keys.get(keyIndex);
    }

    @Override
    public int getRowCount() {
        return this.keys.size() * this.gui.getDataSetCount();
    }

    @Override
    public String[] getAllColumns() {
        return COLUMN_NAMES;
    }

    @Override
    public boolean getDefaultColumnState(int column) {
        return DEFAULT_COLUMNS[column];
    }

    @Override
    public boolean canDisableColumn(int column) {
        return column >= 3;
    }

    @Override
    protected Class<?> getEnabledColumnClass(int columnIndex) {
        if (columnIndex < 3) {
            return String.class;
        }
        if (columnIndex == 9) {
            return Integer.class;
        }
        return Double.class;
    }

    @Override
    protected String getEnabledColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    protected Object getEnabledValueAt(int rowIndex, int columnIndex) {
        int fileIndex = rowIndex % this.gui.getDataSetCount();
        DataSet data = null;
        int n = 0;
        for (DataSet dataSet : this.gui.getDataSets()) {
            if (n++ != fileIndex) continue;
            data = dataSet;
            break;
        }
        if (data == null) {
            throw new ArrayIndexOutOfBoundsException(rowIndex);
        }
        int keyIndex = rowIndex / this.gui.getDataSetCount();
        String string = (String)this.keys.get(keyIndex);
        switch (columnIndex) {
            case 0: {
                return data.toString();
            }
            case 1: {
                return this.analysisSet.getType(string);
            }
            case 2: {
                return this.analysisSet.getField(string);
            }
            case 3: {
                return this.gui.getAnalysis(data).getMinimum(this.analysisSet.getType(string), this.analysisSet.getField(string));
            }
            case 4: {
                return this.gui.getAnalysis(data).getAverage(this.analysisSet.getType(string), this.analysisSet.getField(string));
            }
            case 5: {
                return this.gui.getAnalysis(data).getMaximum(this.analysisSet.getType(string), this.analysisSet.getField(string));
            }
            case 6: {
                return this.gui.getAnalysis(data).getStandardDeviation(this.analysisSet.getType(string), this.analysisSet.getField(string));
            }
            case 7: {
                return this.gui.getAnalysis(data).getMedian(this.analysisSet.getType(string), this.analysisSet.getField(string));
            }
            case 8: {
                return this.gui.getAnalysis(data).getSum(this.analysisSet.getType(string), this.analysisSet.getField(string));
            }
            case 9: {
                return this.gui.getAnalysis(data).getCount(this.analysisSet.getType(string), this.analysisSet.getField(string));
            }
            case 10: {
                return this.gui.getAnalysis(data).getGranularityMaximum(this.analysisSet.getType(string), this.analysisSet.getField(string));
            }
        }
        return new ArrayIndexOutOfBoundsException(columnIndex);
    }

    @Override
    public void fireTableRowsInserted(int firstRow, int lastRow) {
        for (int i = firstRow; i <= lastRow; ++i) {
            for (int j = 0; j < this.gui.getDataSetCount(); ++j) {
                int actualRow = i * this.gui.getDataSetCount() + j;
                super.fireTableRowsInserted(actualRow, actualRow);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("granularity".equals(evt.getPropertyName())) {
            this.updateGranularityMax();
        }
    }

    void updateGranularityMax() {
        ByStatisticTableModel.COLUMN_NAMES[ByStatisticTableModel.COLUMN_NAMES.length - 1] = Statistic.GRANULARITY_MAXIMUM.getName(this.gui.getGranularity());
        this.buildColumnNameMap();
        if (this.enabledColumns.get(COLUMN_NAMES.length - 1)) {
            this.fireTableStructureChanged();
        }
    }

    static {
        if (COLUMN_NAMES.length != DEFAULT_COLUMNS.length) {
            throw new IllegalArgumentException("default values array size not equal to column names size " + COLUMN_NAMES.length + " != " + DEFAULT_COLUMNS.length);
        }
    }
}

